/*
 * Decompiled with CFR 0.152.
 */
package filius.software.netzzugangsschicht;

import filius.hardware.NetzwerkInterface;
import filius.rahmenprogramm.nachrichten.Lauscher;
import filius.software.ProtokollThread;
import filius.software.netzzugangsschicht.Ethernet;
import filius.software.netzzugangsschicht.EthernetFrame;
import filius.software.system.SystemSoftware;
import filius.software.vermittlungsschicht.ArpPaket;
import filius.software.vermittlungsschicht.IcmpPaket;
import filius.software.vermittlungsschicht.IpPaket;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EthernetThread
extends ProtokollThread<EthernetFrame> {
    private static Logger LOG = LoggerFactory.getLogger(EthernetThread.class);
    private NetzwerkInterface netzwerkInterface;
    private SystemSoftware systemSoftware;
    private Ethernet ethernet;

    public EthernetThread(Ethernet ethernet, NetzwerkInterface nic, SystemSoftware systemSoftware) {
        super(nic.getPort().holeEingangsPuffer());
        LOG.trace("INVOKED-2 (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (EthernetThread), constr: EthernetThread(" + String.valueOf(ethernet) + "," + String.valueOf(nic) + ")");
        this.ethernet = ethernet;
        this.netzwerkInterface = nic;
        this.systemSoftware = systemSoftware;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void verarbeiteDatenEinheit(EthernetFrame etp) {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (EthernetThread), verarbeiteDateneinheit(" + etp.toString() + ")");
        Lauscher.getLauscher().addDatenEinheit(this.netzwerkInterface, this.systemSoftware, etp);
        if (!etp.getZielMacAdresse().equalsIgnoreCase("FF:FF:FF:FF:FF:FF") && !etp.getZielMacAdresse().equals(this.netzwerkInterface.getMac())) {
            return;
        }
        etp.getDaten().setRcvNic(this.netzwerkInterface);
        if (etp.getTyp().equals("0x800")) {
            IpPaket ipPacket = (IpPaket)etp.getDaten();
            if (ipPacket.getProtocol() == 1) {
                LinkedList<IcmpPaket> linkedList = this.ethernet.holeICMPPuffer();
                synchronized (linkedList) {
                    this.ethernet.holeICMPPuffer().add((IcmpPaket)ipPacket);
                    this.ethernet.holeICMPPuffer().notifyAll();
                }
            } else {
                LinkedList<IpPaket> linkedList = this.ethernet.holeIPPuffer();
                synchronized (linkedList) {
                    this.ethernet.holeIPPuffer().add(ipPacket);
                    this.ethernet.holeIPPuffer().notify();
                }
            }
        } else if (etp.getTyp().equals("0x806")) {
            LinkedList<ArpPaket> linkedList = this.ethernet.holeARPPuffer();
            synchronized (linkedList) {
                this.ethernet.holeARPPuffer().add((ArpPaket)etp.getDaten());
                this.ethernet.holeARPPuffer().notify();
            }
        } else {
            LOG.info("Paket konnte nicht zugeordnet werden");
        }
    }
}

