/*
 * Decompiled with CFR 0.152.
 */
package filius.software.netzzugangsschicht;

import filius.hardware.knoten.Modem;
import filius.software.ProtokollThread;
import filius.software.netzzugangsschicht.EthernetFrame;
import filius.software.system.ModemFirmware;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModemEmpfaenger
extends ProtokollThread<EthernetFrame> {
    private static Logger LOG = LoggerFactory.getLogger(ModemEmpfaenger.class);
    private ModemFirmware firmware;
    private InputStream in;

    public ModemEmpfaenger(ModemFirmware firmware, InputStream in) {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (ModemAnschlussBeobachterExtern), constr: ModemAnschlussBeobachterExtern(" + String.valueOf(firmware) + "," + String.valueOf(in) + ")");
        this.firmware = firmware;
        this.in = in;
    }

    @Override
    public void run() {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (ModemAnschlussBeobachterExtern), run()");
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(this.in);
        }
        catch (IOException e) {
            LOG.debug("", e);
        }
        while (this.running) {
            try {
                EthernetFrame object = (EthernetFrame)in.readObject();
                this.verarbeiteDatenEinheit(object);
            }
            catch (Exception e) {
                LOG.debug("", e);
                if (!this.running) continue;
                this.firmware.verbindungZuruecksetzen();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void verarbeiteDatenEinheit(EthernetFrame datenEinheit) {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (ModemAnschlussBeobachterExtern), verarbeiteDatenEinheit(" + datenEinheit.toString() + ")");
        if (this.firmware.isStarted()) {
            LinkedList<EthernetFrame> linkedList = ((Modem)this.firmware.getKnoten()).getErstenAnschluss().holeAusgangsPuffer();
            synchronized (linkedList) {
                ((Modem)this.firmware.getKnoten()).getErstenAnschluss().holeAusgangsPuffer().add(datenEinheit);
                ((Modem)this.firmware.getKnoten()).getErstenAnschluss().holeAusgangsPuffer().notify();
            }
        }
    }

    @Override
    public void starten() {
        super.starten();
    }

    @Override
    public void beenden() {
        super.beenden();
    }
}

