/*
 * Decompiled with CFR 0.152.
 */
package filius.software.rip;

import filius.exception.VerbindungsException;
import filius.hardware.NetzwerkInterface;
import filius.hardware.knoten.InternetKnoten;
import filius.software.clientserver.ClientAnwendung;
import filius.software.rip.RIPMessage;
import filius.software.rip.RIPMessageRoute;
import filius.software.rip.RIPRoute;
import filius.software.rip.RIPTable;
import filius.software.rip.RIPUtil;
import filius.software.system.VermittlungsrechnerBetriebssystem;
import filius.software.transportschicht.UDPSocket;
import java.util.Random;

public class RIPBeacon
extends ClientAnwendung {
    private Random rand;

    @Override
    public void starten() {
        super.starten();
        this.rand = new Random();
        this.ausfuehren("announce", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void announce() {
        UDPSocket sock;
        VermittlungsrechnerBetriebssystem bs = (VermittlungsrechnerBetriebssystem)this.getSystemSoftware();
        RIPTable table = bs.getRIPTable();
        try {
            sock = new UDPSocket(bs, "255.255.255.255", 520, 521);
            sock.verbinden();
        }
        catch (VerbindungsException e) {
            return;
        }
        while (this.running) {
            RIPTable rIPTable = table;
            synchronized (rIPTable) {
                while (table.getNextBeacon() - RIPUtil.getTime() > 0L) {
                    try {
                        table.wait(table.getNextBeacon() - RIPUtil.getTime());
                    }
                    catch (InterruptedException interruptedException) {}
                }
                table.check();
                this.broadcast(sock, bs, table);
                table.setNextBeacon(RIPUtil.getTime() + (long)((int)(30000.0 * ((double)(this.rand.nextFloat() / 3.0f) + 0.84))));
            }
        }
        sock.beenden();
    }

    public void broadcast(UDPSocket sock, VermittlungsrechnerBetriebssystem bs, RIPTable table) {
        InternetKnoten knoten = (InternetKnoten)bs.getKnoten();
        for (NetzwerkInterface nic : knoten.getNetzwerkInterfaces()) {
            RIPMessage msg = new RIPMessage(nic.getIp(), bs.primaryIPAdresse(), 16, 75000);
            for (RIPRoute route : table.routes) {
                if (nic.getIp().equals(route.getInterfaceIpAddress())) continue;
                msg.addRoute(new RIPMessageRoute(route.getNetAddress(), route.getNetMask(), route.hops));
            }
            sock.bind(nic.getIp());
            sock.senden(msg.toString());
        }
    }
}

