/*
 * Decompiled with CFR 0.152.
 */
package filius.software.rip;

import filius.hardware.NetzwerkInterface;
import filius.hardware.knoten.InternetKnoten;
import filius.software.rip.RIPRoute;
import filius.software.rip.RIPUtil;
import filius.software.system.InternetKnotenBetriebssystem;
import filius.software.vermittlungsschicht.IP;
import java.util.LinkedList;

public class RIPTable {
    public static final int INFINITY = 16;
    public static final int INTERVAL = 30000;
    public static final int TIMEOUT = 75000;
    public LinkedList<RIPRoute> routes;
    private long nextBeacon;
    private InternetKnotenBetriebssystem bs;

    public RIPTable(InternetKnotenBetriebssystem bs) {
        this.bs = bs;
        this.reset();
    }

    public void reset() {
        this.routes = new LinkedList();
        this.setNextBeacon(RIPUtil.getTime() + 1000L);
    }

    public void addRoute(RIPRoute route) {
        this.routes.add(route);
    }

    public void addLocalRoutes(InternetKnoten knoten) {
        for (NetzwerkInterface nic : knoten.getNetzwerkInterfaces()) {
            long netMask = IP.inetAton(nic.getSubnetzMaske());
            long netAddr = IP.inetAton(nic.getIp()) & netMask;
            this.addRoute(new RIPRoute(0, IP.inetNtoa(netAddr), IP.inetNtoa(netMask), nic.getIp(), this.bs.primaryIPAdresse(), nic.getIp(), 0));
        }
    }

    public RIPRoute search(String net, String mask) {
        for (RIPRoute route : this.routes) {
            if (!route.getNetAddress().equals(net) || !route.getNetMask().equals(mask)) continue;
            return route;
        }
        return null;
    }

    public void check() {
        for (RIPRoute route : this.routes) {
            if (!route.isExpired()) continue;
            route.hops = 16;
        }
    }

    public long getNextBeacon() {
        return this.nextBeacon;
    }

    public void setNextBeacon(long nextBeacon) {
        this.nextBeacon = nextBeacon;
    }
}

