/*
 * Decompiled with CFR 0.152.
 */
package filius.software.system;

import filius.software.system.Datei;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dateisystem
implements Serializable {
    private static Logger LOG = LoggerFactory.getLogger(Dateisystem.class);
    public static final String FILE_SEPARATOR = "/";
    private DefaultMutableTreeNode root;

    public Dateisystem() {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (Dateisystem), constr: Dateisystem()");
        this.root = new DefaultMutableTreeNode("root");
    }

    @Deprecated
    public DefaultMutableTreeNode getArbeitsVerzeichnis() {
        return this.root;
    }

    @Deprecated
    public void setArbeitsVerzeichnis(DefaultMutableTreeNode arbeitsVerzeichnis) {
        this.root = arbeitsVerzeichnis;
    }

    public void printTree() {
        this.printSubtree("", this.root);
    }

    private void printSubtree(String indent, DefaultMutableTreeNode tmpRoot) {
        if (!(tmpRoot.getUserObject() instanceof Datei)) {
            LOG.debug((String)indent + "--[" + tmpRoot.getUserObject().toString() + "]");
        }
        indent = (String)indent + " |";
        Enumeration<TreeNode> e = tmpRoot.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            this.printSubtree((String)indent, node);
        }
    }

    public boolean dateiVorhanden(DefaultMutableTreeNode verzeichnis, String dateiName) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (Dateisystem), dateiVorhanden(" + String.valueOf(verzeichnis) + "," + dateiName + ")");
        if (verzeichnis == null) {
            return false;
        }
        Enumeration<TreeNode> e = verzeichnis.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode enode = (DefaultMutableTreeNode)e.nextElement();
            if (!enode.getUserObject().toString().equalsIgnoreCase(dateiName)) continue;
            return true;
        }
        return false;
    }

    public boolean dateiVorhanden(String verzeichnis, String dateiName) {
        return this.dateiVorhanden(this.verzeichnisKnoten(verzeichnis), dateiName);
    }

    public static String absoluterPfad(DefaultMutableTreeNode node) {
        StringBuffer buffer = new StringBuffer();
        for (Object pathElement : ArrayUtils.remove(node.getUserObjectPath(), 0)) {
            buffer.append(FILE_SEPARATOR).append(pathElement);
        }
        if (buffer.length() == 0) {
            buffer.append(FILE_SEPARATOR);
        }
        return buffer.toString();
    }

    public String holeRootPfad() {
        return Dateisystem.absoluterPfad(this.root);
    }

    public DefaultMutableTreeNode verzeichnisKnoten(String pfad) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + ", verzeichnisKnoten(" + pfad + ")");
        pfad = Dateisystem.stripRoot(Dateisystem.evaluatePathString(pfad));
        if (pfad.equals(FILE_SEPARATOR) || pfad.isEmpty()) {
            return this.root;
        }
        Enumeration<TreeNode> enumeration = this.root.preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!pfad.equalsIgnoreCase(Dateisystem.absoluterPfad(node))) continue;
            return node;
        }
        return null;
    }

    public static DefaultMutableTreeNode verzeichnisKnoten(DefaultMutableTreeNode verzeichnis, String pfad) {
        LOG.trace("INVOKED (static) filius.software.system.Dateisystem, verzeichnisKnoten(" + String.valueOf(verzeichnis) + "," + pfad + ")");
        String absolutePath = pfad.length() > 0 && pfad.substring(0, 1).equals(FILE_SEPARATOR) ? Dateisystem.evaluatePathString(pfad) : Dateisystem.evaluatePathString(Dateisystem.absoluterPfad(verzeichnis) + FILE_SEPARATOR + pfad);
        Enumeration<TreeNode> enumeration = verzeichnis.preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!absolutePath.equalsIgnoreCase(Dateisystem.absoluterPfad(node))) continue;
            return node;
        }
        return null;
    }

    public boolean deleteFile(String absolutePath) {
        LOG.debug("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (Dateisystem), deleteFile(" + absolutePath + ")");
        DefaultMutableTreeNode node = this.verzeichnisKnoten(absolutePath);
        if (node != null) {
            node.removeFromParent();
            return true;
        }
        return false;
    }

    public Datei holeDatei(String dateiPfad) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (Dateisystem), holeDatei(" + dateiPfad + ")");
        DefaultMutableTreeNode node = this.verzeichnisKnoten(dateiPfad);
        if (node != null && node.getUserObject() instanceof Datei) {
            return (Datei)node.getUserObject();
        }
        return null;
    }

    public Datei holeDatei(DefaultMutableTreeNode verzeichnis, String dateiPfad) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (Dateisystem), holeDatei(" + String.valueOf(verzeichnis) + "," + dateiPfad + ")");
        String absoluterDateiPfad = Dateisystem.absoluterPfad(verzeichnis) + FILE_SEPARATOR + dateiPfad;
        return this.holeDatei(absoluterDateiPfad);
    }

    public Datei holeDatei(String verzeichnisPfad, String dateiPfad) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (Dateisystem), holeDatei(" + verzeichnisPfad + "," + dateiPfad + ")");
        String absoluterDateiPfad = verzeichnisPfad + FILE_SEPARATOR + dateiPfad;
        return this.holeDatei(absoluterDateiPfad);
    }

    public List<Datei> dateiSuche(String suchVerzeichnis, String suchString) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (Dateisystem), dateiSuche(" + suchVerzeichnis + "," + suchString + ")");
        LinkedList<Datei> dateien = new LinkedList<Datei>();
        Enumeration<TreeNode> e = this.verzeichnisKnoten(suchVerzeichnis).children();
        while (e.hasMoreElements()) {
            Datei tmpDatei;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            if (!(node.getUserObject() instanceof Datei) || !(tmpDatei = (Datei)node.getUserObject()).getName().toLowerCase().matches("(.+)?" + suchString.toLowerCase() + "(.+)?")) continue;
            dateien.add(tmpDatei);
        }
        return dateien;
    }

    public boolean speicherDatei(String verzeichnisPfad, Datei datei) {
        LOG.debug("speicherDatei(" + verzeichnisPfad + "," + String.valueOf(datei) + ")");
        DefaultMutableTreeNode node = null;
        node = this.verzeichnisKnoten(verzeichnisPfad);
        if (node != null) {
            if (!this.dateiVorhanden(node, datei.getName())) {
                DefaultMutableTreeNode dateiNode = new DefaultMutableTreeNode(datei);
                node.add(dateiNode);
            } else {
                node = this.verzeichnisKnoten(verzeichnisPfad + FILE_SEPARATOR + datei.getName());
                Datei file = (Datei)node.getUserObject();
                file.setDateiInhalt(datei.getDateiInhalt());
                file.setDateiTyp(datei.getDateiTyp());
                file.setSize(datei.holeGroesse());
            }
            return true;
        }
        LOG.debug("Datei " + String.valueOf(datei) + " konnte nicht gespeichert werden, weil Verzeichnis " + verzeichnisPfad + " nicht existiert.");
        return false;
    }

    public boolean speicherDatei(DefaultMutableTreeNode verzeichnis, Datei datei) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + ", speicherDatei(" + String.valueOf(verzeichnis) + "," + String.valueOf(datei) + ")");
        return this.speicherDatei(Dateisystem.absoluterPfad(verzeichnis), datei);
    }

    public boolean erstelleVerzeichnis(String verzeichnisPfad, String neuesVerzeichnis) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + ", erstelleVerzeichnis(" + verzeichnisPfad + "," + neuesVerzeichnis + ")");
        DefaultMutableTreeNode neuerNode = null;
        String absPath = neuesVerzeichnis.length() > 0 && neuesVerzeichnis.substring(0, 1).equals(FILE_SEPARATOR) ? Dateisystem.evaluatePathString(neuesVerzeichnis) : Dateisystem.evaluatePathString(verzeichnisPfad + FILE_SEPARATOR + neuesVerzeichnis);
        verzeichnisPfad = Dateisystem.getDirectory(absPath);
        neuesVerzeichnis = Dateisystem.getBasename(absPath);
        DefaultMutableTreeNode node = this.verzeichnisKnoten(verzeichnisPfad);
        if (node != null) {
            if (this.dateiVorhanden(node, neuesVerzeichnis)) {
                LOG.debug("WARNING (" + this.hashCode() + "): Verzeichnis " + neuesVerzeichnis + " wurde nicht erzeugt, weil es im Verzeichnis " + verzeichnisPfad + " bereits existiert.");
            } else {
                neuerNode = new DefaultMutableTreeNode(neuesVerzeichnis);
                node.add(neuerNode);
            }
            return true;
        }
        return false;
    }

    public boolean erstelleVerzeichnis(DefaultMutableTreeNode verzeichnis, String neuesVerzeichnis) {
        return this.erstelleVerzeichnis(Dateisystem.absoluterPfad(verzeichnis), neuesVerzeichnis);
    }

    public List<Datei> holeDateien(DefaultMutableTreeNode node) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + ", holeDateien(" + String.valueOf(node) + ")");
        LinkedList<Datei> liste = new LinkedList<Datei>();
        if (node == null) {
            return null;
        }
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.nextElement();
            if (!(n.getUserObject() instanceof Datei)) continue;
            Datei dat = (Datei)n.getUserObject();
            liste.add(dat);
        }
        return liste;
    }

    public List<Object> listeVerzeichnis(DefaultMutableTreeNode verzeichnis) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + ", listeVerzeichnis(" + String.valueOf(verzeichnis) + ")");
        LinkedList<Object> liste = new LinkedList<Object>();
        if (verzeichnis == null) {
            return null;
        }
        Enumeration<TreeNode> enumeration = verzeichnis.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode tmpNode = (DefaultMutableTreeNode)enumeration.nextElement();
            liste.addLast(tmpNode.getUserObject());
        }
        return liste;
    }

    public DefaultMutableTreeNode getRoot() {
        return this.root;
    }

    public void setRoot(DefaultMutableTreeNode root) {
        this.root = root;
    }

    public void fixDirectory(DefaultMutableTreeNode root) {
        if (root.getAllowsChildren()) {
            for (int i = 0; i < root.getChildCount(); ++i) {
                this.fixDirectory((DefaultMutableTreeNode)root.getChildAt(i));
            }
        }
        if (root.getUserObject() == null) {
            root.setUserObject("restored-" + System.currentTimeMillis());
        } else if (root.getUserObject() instanceof Datei && ((Datei)root.getUserObject()).getName().isEmpty()) {
            ((Datei)root.getUserObject()).setName("restored-" + System.currentTimeMillis());
        }
    }

    public DefaultMutableTreeNode changeDirectory(String path) {
        DefaultMutableTreeNode newDir = this.verzeichnisKnoten(this.toAbsolutePath(path));
        return newDir;
    }

    public DefaultMutableTreeNode changeDirectory(String currDir, String relPath) {
        return this.changeDirectory(currDir + FILE_SEPARATOR + relPath);
    }

    public static String evaluatePathString(String path) {
        LOG.trace("INVOKED (static) filius.software.system.Dateisystem, evaluatePathString(" + path + ")");
        Object result = "";
        StringTokenizer tk = new StringTokenizer(path, FILE_SEPARATOR);
        String[] pathElements = new String[tk.countTokens()];
        int currIndex = -1;
        while (tk.hasMoreTokens()) {
            String currString = tk.nextToken();
            if (currString.equals("..")) {
                --currIndex;
                continue;
            }
            if (currString.equals(".") || currString.equals("")) continue;
            pathElements[++currIndex] = currString;
        }
        for (int i = 0; i <= currIndex; ++i) {
            result = (String)result + pathElements[i];
            if (i >= currIndex) continue;
            result = (String)result + FILE_SEPARATOR;
        }
        if (currIndex >= 0 && path.substring(0, 1).equals(FILE_SEPARATOR)) {
            result = FILE_SEPARATOR + (String)result;
        }
        return result;
    }

    private static String stripRoot(String path) {
        LOG.trace("INVOKED (static) filius.software.system.Dateisystem, stripRoot(" + path + ")");
        if (path.indexOf(FILE_SEPARATOR) >= 0) {
            return path.substring(path.indexOf(FILE_SEPARATOR));
        }
        return path;
    }

    public static String getDirectory(String path) {
        LOG.trace("INVOKED (static) filius.software.system.Dateisystem, getDirectory(" + path + ")");
        if (path.lastIndexOf(FILE_SEPARATOR) >= 0) {
            return path.substring(0, path.lastIndexOf(FILE_SEPARATOR));
        }
        return "";
    }

    public static String getBasename(String path) {
        LOG.trace("INVOKED (static) filius.software.system.Dateisystem, getBasename(" + path + ")");
        if (path.lastIndexOf(FILE_SEPARATOR) >= 0) {
            return path.substring(path.lastIndexOf(FILE_SEPARATOR) + 1);
        }
        return path;
    }

    public String toAbsolutePath(String path) {
        return this.toAbsolutePath(this.root, path);
    }

    public String toAbsolutePath(DefaultMutableTreeNode currentDir, String path) {
        Object absolutePath = StringUtils.startsWith(path, FILE_SEPARATOR) ? path : Dateisystem.absoluterPfad(currentDir) + FILE_SEPARATOR + path;
        return absolutePath;
    }
}

