/*
 * Decompiled with CFR 0.152.
 */
package filius.software.system;

import filius.hardware.NetzwerkInterface;
import filius.hardware.Verbindung;
import filius.hardware.knoten.Gateway;
import filius.hardware.knoten.Knoten;
import filius.rahmenprogramm.EingabenUeberpruefung;
import filius.rahmenprogramm.Information;
import filius.rahmenprogramm.ResourceUtil;
import filius.software.firewall.Firewall;
import filius.software.firewall.FirewallWebKonfig;
import filius.software.firewall.FirewallWebLog;
import filius.software.nat.InetAddress;
import filius.software.nat.NatEntry;
import filius.software.nat.NatGateway;
import filius.software.nat.NetworkAddressTranslationTable;
import filius.software.nat.PortProtocolPair;
import filius.software.rip.RIPTable;
import filius.software.system.InternetKnotenBetriebssystem;
import filius.software.www.WebServer;
import java.beans.PropertyChangeEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GatewayFirmware
extends InternetKnotenBetriebssystem {
    private static Logger LOG = LoggerFactory.getLogger(GatewayFirmware.class);
    private long retentionTime = 300000L;
    private boolean natMethodChanged = false;
    private LinkedList<String[]> staticNAT = null;

    public long getRetentionTime() {
        return this.retentionTime * (long)Verbindung.holeVerzoegerungsFaktor();
    }

    public void setNatMethodChanged(boolean b) {
        this.natMethodChanged = b;
    }

    public void setStaticNAT(LinkedList<String[]> staticNAT) {
        this.staticNAT = new LinkedList<String[]>(staticNAT);
    }

    public LinkedList<String[]> getStaticNAT() {
        return this.staticNAT;
    }

    public GatewayFirmware() {
        LOG.trace("INVOKED-2 (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (VermittlungsrechnerBetriebssystem), constr: VermittlungsrechnerBetriebssystem()");
        this.setIpForwardingEnabled(true);
        this.initialisiereAnwendungen();
    }

    @Override
    public void setKnoten(Knoten gateway) {
        super.setKnoten(gateway);
        this.getDHCPServer().bindAddress(List.of(((Gateway)gateway).holeLANInterface()));
    }

    @Override
    public String dhcpEnabledMACAddress() {
        return ((Gateway)this.getKnoten()).holeWANInterface().getMac();
    }

    @Override
    public NetzwerkInterface primaryNetworkInterface() {
        return ((Gateway)this.getKnoten()).holeLANInterface();
    }

    private void initialisiereAnwendungen() {
        WebServer server = null;
        Firewall firewall = null;
        this.staticNAT = new LinkedList();
        this.installApp("filius.software.nat.NatGateway");
        this.installApp("filius.software.www.WebServer");
        firewall = this.holeFirewall();
        server = this.holeWebServer();
        firewall.setDefaultPolicy((short)0);
        firewall.setActivated(false);
        FirewallWebLog weblog = new FirewallWebLog();
        weblog.setFirewall(firewall);
        weblog.setPfad("log");
        server.setzePlugIn(weblog);
        FirewallWebKonfig webkonfig = new FirewallWebKonfig();
        webkonfig.setWebserver(server);
        webkonfig.setFirewall(firewall);
        webkonfig.setPfad("konfig");
        server.setzePlugIn(webkonfig);
        server.erzeugeIndexDatei(ResourceUtil.getResourcePath("tmpl/gateway_index_" + String.valueOf(Information.getInformation().getLocaleOrDefault()) + ".txt"));
    }

    @Override
    public void starten() {
        super.starten();
        this.holeWebServer().setAktiv(true);
        final Timer timer = new Timer();
        NetworkAddressTranslationTable nat = ((NatGateway)this.holeFirewall()).getNATTable();
        nat.resetStaticNATTable();
        if (!this.staticNAT.isEmpty()) {
            for (int i = 0; i < this.staticNAT.size(); ++i) {
                String[] entry = this.staticNAT.get(i);
                if (!this.validateData(entry).booleanValue()) continue;
                int protocol = switch (entry[0].toUpperCase()) {
                    case "TCP" -> 6;
                    case "UDP" -> 17;
                    default -> Integer.parseInt(entry[0]);
                };
                InetAddress lanAddress = new InetAddress(entry[2], Integer.parseInt(entry[3]), protocol);
                nat.addStatic(Integer.parseInt(entry[1]), protocol, lanAddress);
            }
        }
        this.fireNATPropertyChange();
        final ConcurrentHashMap<PortProtocolPair, NatEntry> dynNat = nat.getDynamicNATTable();
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (!GatewayFirmware.this.isStarted()) {
                    timer.cancel();
                } else if (!dynNat.isEmpty()) {
                    GatewayFirmware.this.checkNAT();
                }
            }
        }, 1000L, 1000L);
        if (this.natMethodChanged) {
            this.firePropertyChanged(new PropertyChangeEvent(this, "nat_method", null, null));
            this.natMethodChanged = false;
        }
    }

    private Boolean validateData(String[] entry) {
        for (int i = 0; i < entry.length; ++i) {
            Pattern pattern = null;
            switch (i) {
                case 0: {
                    pattern = EingabenUeberpruefung.musterProtocol;
                    break;
                }
                case 1: {
                    pattern = EingabenUeberpruefung.musterPort;
                    break;
                }
                case 2: {
                    pattern = EingabenUeberpruefung.musterIpAdresse;
                    break;
                }
                case 3: {
                    pattern = EingabenUeberpruefung.musterPort;
                }
            }
            if (EingabenUeberpruefung.isGueltig(entry[i], pattern)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void beenden() {
        super.beenden();
    }

    public Firewall holeFirewall() {
        Firewall firewall = (Firewall)this.holeSoftware("filius.software.firewall.Firewall");
        if (null == firewall) {
            firewall = (NatGateway)this.holeSoftware("filius.software.nat.NatGateway");
        }
        return firewall;
    }

    public WebServer holeWebServer() {
        return (WebServer)this.holeSoftware("filius.software.www.WebServer");
    }

    @Override
    public RIPTable getRIPTable() {
        return null;
    }

    @Override
    public boolean isRipEnabled() {
        return false;
    }

    public Vector<Vector<String>> holeNAT() {
        Vector<Object> eintrag;
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (GatewayFirmware), holeNAT()");
        NetworkAddressTranslationTable nat = null;
        nat = ((NatGateway)this.holeFirewall()).getNATTable();
        Vector<Vector<String>> eintraege = new Vector<Vector<String>>();
        for (PortProtocolPair key : nat.getStaticNATTable().keySet()) {
            eintrag = new Vector();
            eintrag = this.createEintrag(key.getProtocol(), "*", key.getPort(), nat.getStaticNATTable().get(key).getInetAddress().getIpAddress(), nat.getStaticNATTable().get(key).getInetAddress().getPort(), null);
            eintraege.add(eintrag);
        }
        for (PortProtocolPair key : nat.getDynamicNATTable().keySet()) {
            eintrag = new Vector();
            eintrag = this.createEintrag(key.getProtocol(), key.getProtocol() == 1 ? "*" : key.getAddress(), key.getPort(), nat.getDynamicNATTable().get(key).getInetAddress().getIpAddress(), nat.getDynamicNATTable().get(key).getInetAddress().getPort(), nat.getDynamicNATTable().get(key).getLastUpdate());
            eintraege.add(eintrag);
        }
        return eintraege;
    }

    private Vector<String> createEintrag(int prot, String wanAddress, int mappedPort, String lanAddress, int lanPort, Date update) {
        Vector<String> eintrag = new Vector<String>();
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
        eintrag.add((String)(switch (prot) {
            case 6 -> "TCP";
            case 17 -> "UDP";
            case 1 -> "ICMP";
            default -> "" + prot;
        }));
        eintrag.add("" + mappedPort);
        eintrag.add(wanAddress);
        eintrag.add(lanAddress);
        eintrag.add("" + lanPort);
        if (update == null) {
            eintrag.add("-");
        } else {
            eintrag.add(formatter.format(update));
        }
        return eintrag;
    }

    public void loescheNAT() {
        ConcurrentHashMap<PortProtocolPair, NatEntry> nat = ((NatGateway)this.holeFirewall()).getNATTable().getDynamicNATTable();
        nat.clear();
        this.firePropertyChanged(new PropertyChangeEvent(this, "nat_entry", null, null));
    }

    public void checkNAT() {
        Date jetzt = new Date();
        ConcurrentHashMap<PortProtocolPair, NatEntry> nat = ((NatGateway)this.holeFirewall()).getNATTable().getDynamicNATTable();
        nat.forEach((portProtocolPair, natEntry) -> {
            if (jetzt.getTime() - natEntry.getLastUpdate().getTime() >= this.getRetentionTime()) {
                nat.remove(portProtocolPair);
                this.firePropertyChanged(new PropertyChangeEvent(this, "nat_entry", null, null));
            }
        });
    }

    public void fireNATPropertyChange() {
        this.firePropertyChanged(new PropertyChangeEvent(this, "nat_entry", null, null));
    }
}

