/*
 * Decompiled with CFR 0.152.
 */
package filius.software.system;

import filius.hardware.NetzwerkInterface;
import filius.hardware.knoten.InternetKnoten;
import filius.rahmenprogramm.EingabenUeberpruefung;
import filius.rahmenprogramm.FiliusClassLoader;
import filius.rahmenprogramm.Information;
import filius.software.Anwendung;
import filius.software.dhcp.DHCPClient;
import filius.software.dhcp.DHCPServer;
import filius.software.dns.Resolver;
import filius.software.netzzugangsschicht.Ethernet;
import filius.software.rip.RIPTable;
import filius.software.system.Dateisystem;
import filius.software.system.SystemSoftware;
import filius.software.transportschicht.TCP;
import filius.software.transportschicht.UDP;
import filius.software.vermittlungsschicht.ARP;
import filius.software.vermittlungsschicht.ICMP;
import filius.software.vermittlungsschicht.IP;
import filius.software.vermittlungsschicht.Route;
import filius.software.vermittlungsschicht.RouteNotFoundException;
import filius.software.vermittlungsschicht.Weiterleitungstabelle;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InternetKnotenBetriebssystem
extends SystemSoftware {
    private static Logger LOG = LoggerFactory.getLogger(InternetKnotenBetriebssystem.class);
    private Dateisystem dateisystem;
    private DHCPServer dhcpServer;
    private boolean dhcpKonfiguration;
    private DHCPClient dhcpClient;
    private HashMap<String, Anwendung> installierteAnwendung;
    private boolean ipForwardingEnabled;
    private Resolver dnsclient;
    private TCP tcp;
    private UDP udp;
    private ARP arpVermittlung;
    private IP vermittlung;
    private ICMP icmpVermittlung;
    private Weiterleitungstabelle weiterleitungstabelle;
    private Ethernet ethernet;

    public InternetKnotenBetriebssystem() {
        LOG.trace("(InternetKnotenBetriebssystem), constr: InternetKnotenBetriebssystem()");
        this.installierteAnwendung = new HashMap();
        this.weiterleitungstabelle = new Weiterleitungstabelle();
        this.weiterleitungstabelle.setInternetKnotenBetriebssystem(this);
        this.arpVermittlung = new ARP(this);
        this.vermittlung = new IP(this);
        this.icmpVermittlung = new ICMP(this);
        this.ethernet = new Ethernet(this);
        this.tcp = new TCP(this);
        this.udp = new UDP(this);
        this.dateisystem = new Dateisystem();
        this.dnsclient = new Resolver();
        this.dnsclient.setSystemSoftware(this);
        this.dhcpServer = new DHCPServer();
        this.dhcpServer.setSystemSoftware(this);
        LOG.trace("InternetKnotenBetriebssystem initialized");
    }

    @Override
    public void beenden() {
        super.beenden();
        LOG.trace("(InternetKnotenBetriebssystem), beenden()");
        this.ethernet.beenden();
        this.arpVermittlung.beenden();
        this.vermittlung.beenden();
        this.icmpVermittlung.beenden();
        this.tcp.beenden();
        this.udp.beenden();
        this.dnsclient.beenden();
        this.dhcpServer.beenden();
        if (this.dhcpClient != null) {
            this.dhcpClient.beenden();
        }
        for (Anwendung anwendung : this.installierteAnwendung.values()) {
            anwendung.beenden();
        }
    }

    public DHCPServer getDHCPServer() {
        return this.dhcpServer;
    }

    public void setDHCPServer(DHCPServer dhcpServer) {
        this.dhcpServer = dhcpServer;
    }

    @Override
    public synchronized void starten() {
        super.starten();
        LOG.trace("(InternetKnotenBetriebssystem), starten()");
        this.dateisystem.fixDirectory(this.dateisystem.getRoot());
        this.ethernet.starten();
        this.arpVermittlung.starten();
        this.vermittlung.starten();
        this.icmpVermittlung.starten();
        this.tcp.starten();
        this.udp.starten();
        if (this.dhcpServer.isAktiv()) {
            this.dhcpServer.starten();
        }
        if (this.isDHCPKonfiguration()) {
            this.dhcpClient = new DHCPClient();
            this.dhcpClient.setSystemSoftware(this);
            this.dhcpClient.starten();
        }
        for (Anwendung anwendung : this.installierteAnwendung.values()) {
            if (anwendung == null) continue;
            anwendung.starten();
        }
    }

    public boolean isDHCPKonfiguration() {
        return this.dhcpKonfiguration;
    }

    public void setDHCPKonfiguration(boolean dhcp) {
        this.dhcpKonfiguration = dhcp;
    }

    public Resolver holeDNSClient() {
        return this.dnsclient;
    }

    public TCP holeTcp() {
        return this.tcp;
    }

    public UDP holeUdp() {
        return this.udp;
    }

    public ARP holeARP() {
        return this.arpVermittlung;
    }

    public ICMP holeICMP() {
        return this.icmpVermittlung;
    }

    public IP holeIP() {
        return this.vermittlung;
    }

    public Ethernet holeEthernet() {
        return this.ethernet;
    }

    public Dateisystem getDateisystem() {
        return this.dateisystem;
    }

    public void setDateisystem(Dateisystem dateisystem) {
        this.dateisystem = dateisystem;
    }

    public abstract RIPTable getRIPTable();

    public abstract boolean isRipEnabled();

    public boolean isIpForwardingEnabled() {
        return this.ipForwardingEnabled;
    }

    public void setIpForwardingEnabled(boolean ipForwardingEnabled) {
        this.ipForwardingEnabled = ipForwardingEnabled;
    }

    public void setInstallierteAnwendungen(HashMap<String, Anwendung> anwendungen) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (InternetKnotenBetriebssystem), setInstallierteAnwendungen()");
        this.installierteAnwendung = anwendungen;
    }

    private void printInstallierteAnwendungen() {
        LOG.debug("\tInternetKnotenBetriebssystem: installierte Anwendungen:");
        for (String app : this.installierteAnwendung.keySet()) {
            LOG.debug("\t  - {}", (Object)app);
        }
        LOG.debug("\t  ges: {}", (Object)this.installierteAnwendung);
    }

    public HashMap<String, Anwendung> getInstallierteAnwendungen() {
        return this.installierteAnwendung;
    }

    public Anwendung holeSoftware(String anwendungsklasse) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (InternetKnotenBetriebssystem), holeSoftware(" + anwendungsklasse + ")");
        if (anwendungsklasse == null) {
            return null;
        }
        Anwendung anwendung = this.installierteAnwendung.get(anwendungsklasse);
        if (anwendung == null) {
            return null;
        }
        return anwendung;
    }

    public boolean entferneSoftware(String awKlasse) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (InternetKnotenBetriebssystem), entferneSoftware(" + awKlasse + ")");
        this.printInstallierteAnwendungen();
        boolean entfernt = false;
        Iterator<Map.Entry<String, Anwendung>> it = this.installierteAnwendung.entrySet().iterator();
        while (it.hasNext() && !entfernt) {
            if (!awKlasse.equals(it.next().getKey())) continue;
            it.remove();
            entfernt = true;
        }
        return entfernt;
    }

    public boolean installAppIfAvailable(String klassenname) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (InternetKnotenBetriebssystem), installiereSoftware(" + klassenname + ")");
        this.printInstallierteAnwendungen();
        boolean erfolg = false;
        if (this.checkAlreadyInstalled(klassenname)) {
            LOG.info("App {} could not be installed because app is already installed.", (Object)klassenname);
        } else if (!this.checkAppAvailable(klassenname)) {
            LOG.info("{} could not be installed because app is not in list of available software.", (Object)klassenname);
        } else if (this.installApp(klassenname)) {
            LOG.info("App {} installed.", (Object)klassenname);
            erfolg = true;
        } else {
            LOG.info("App {} could not be installed. An error occurred.", (Object)klassenname);
        }
        return erfolg;
    }

    private boolean checkAlreadyInstalled(String klassenname) {
        return this.holeSoftware(klassenname) != null;
    }

    private boolean checkAppAvailable(String klassenname) {
        boolean available = false;
        try {
            for (Map<String, String> app : Information.getInformation().ladeProgrammListe()) {
                if (!klassenname.equals(app.get("Klasse"))) continue;
                available = true;
            }
        }
        catch (Exception e) {
            LOG.debug("list of applications could not be read.", e);
        }
        return available;
    }

    public boolean installApp(String klassenname) {
        boolean erfolg = true;
        try {
            Class<?> cl = Class.forName(klassenname, true, FiliusClassLoader.getInstance(Thread.currentThread().getContextClassLoader()));
            Anwendung neueAnwendung = (Anwendung)cl.getConstructor(new Class[0]).newInstance(new Object[0]);
            neueAnwendung.setSystemSoftware(this);
            this.installierteAnwendung.put(klassenname, neueAnwendung);
        }
        catch (Exception e) {
            LOG.debug("App could not be instantiated. Probably because class could not be found.", e);
            erfolg = false;
        }
        return erfolg;
    }

    public boolean deinstalliereAnwendung(String anwendungsName) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (InternetKnotenBetriebssystem), deinstalliereAnwendung(" + anwendungsName + ")");
        this.printInstallierteAnwendungen();
        if (anwendungsName == null) {
            return false;
        }
        Anwendung anwendung = this.installierteAnwendung.get(anwendungsName);
        if (anwendung == null) {
            return false;
        }
        this.installierteAnwendung.remove(anwendung.holeAnwendungsName());
        return true;
    }

    public Anwendung[] holeArrayInstallierteSoftware() {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (InternetKnotenBetriebssystem), holeArrayInstallierteSoftware()");
        Iterator<Map.Entry<String, Anwendung>> it = this.installierteAnwendung.entrySet().iterator();
        Anwendung[] anwendungen = new Anwendung[this.installierteAnwendung.size()];
        for (int i = 0; it.hasNext() && i < anwendungen.length; ++i) {
            anwendungen[i] = it.next().getValue();
        }
        return anwendungen;
    }

    public Weiterleitungstabelle getWeiterleitungstabelle() {
        return this.weiterleitungstabelle;
    }

    public Route determineRoute(String ipAddress) throws RouteNotFoundException {
        return this.weiterleitungstabelle.holeWeiterleitungsEintrag(ipAddress);
    }

    public void setWeiterleitungstabelle(Weiterleitungstabelle tabelle) {
        this.weiterleitungstabelle = tabelle;
    }

    public String getStandardGateway() {
        InternetKnoten knoten;
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (InternetKnotenBetriebssystem), getStandardGateway()");
        if (this.getKnoten() instanceof InternetKnoten && (knoten = (InternetKnoten)this.getKnoten()).getNetzwerkInterfaces().size() > 0) {
            NetzwerkInterface nic = knoten.getNetzwerkInterfaces().get(0);
            return nic.getGateway();
        }
        return null;
    }

    public void setStandardGateway(String gateway) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (InternetKnotenBetriebssystem), setStandardGateway(" + gateway + ")");
        String string = gateway = gateway != null && gateway.trim().equals("") ? gateway.trim() : IP.ipCheck(gateway);
        if (gateway != null && EingabenUeberpruefung.isGueltig(gateway, EingabenUeberpruefung.musterIpAdresseAuchLeer) && this.getKnoten() instanceof InternetKnoten) {
            InternetKnoten knoten = (InternetKnoten)this.getKnoten();
            ListIterator<NetzwerkInterface> it = knoten.getNetzwerkInterfaces().listIterator();
            while (it.hasNext()) {
                NetzwerkInterface nic = (NetzwerkInterface)it.next();
                nic.setGateway(gateway);
            }
        }
    }

    public void setzeIPAdresse(String ip) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (InternetKnotenBetriebssystem), setzeIPAdresse(" + ip + ")");
        ip = IP.ipCheck(ip);
        if (ip != null && EingabenUeberpruefung.isGueltig(ip, EingabenUeberpruefung.musterIpAdresse) && this.getKnoten() instanceof InternetKnoten) {
            InternetKnoten knoten = (InternetKnoten)this.getKnoten();
            knoten.getNetzwerkInterfaces().get(0).setIp(ip);
        }
    }

    public String primaryIPAdresse() {
        NetzwerkInterface nic = this.primaryNetworkInterface();
        return null == nic ? null : nic.getIp();
    }

    public NetzwerkInterface primaryNetworkInterface() {
        NetzwerkInterface nic = null;
        if (this.getKnoten() instanceof InternetKnoten) {
            InternetKnoten knoten = (InternetKnoten)this.getKnoten();
            nic = knoten.getNetzwerkInterfaces().get(0);
        }
        return nic;
    }

    public String primaryMACAddress() {
        NetzwerkInterface nic = this.primaryNetworkInterface();
        return null == nic ? null : nic.getMac();
    }

    public List<NetzwerkInterface> allNetworkInterfaces() {
        List<NetzwerkInterface> nicList = Collections.emptyList();
        if (this.getKnoten() instanceof InternetKnoten) {
            InternetKnoten knoten = (InternetKnoten)this.getKnoten();
            nicList = knoten.getNetzwerkInterfaces();
        }
        return nicList;
    }

    public String dhcpEnabledMACAddress() {
        return this.primaryMACAddress();
    }

    public String getDNSServer() {
        InternetKnoten knoten;
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (InternetKnotenBetriebssystem), getDNSServer()");
        if (this.getKnoten() instanceof InternetKnoten && (knoten = (InternetKnoten)this.getKnoten()).getNetzwerkInterfaces().size() > 0) {
            NetzwerkInterface nic = knoten.getNetzwerkInterfaces().get(0);
            return nic.getDns();
        }
        return null;
    }

    public void setDNSServer(String dns) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (InternetKnotenBetriebssystem), setDNSServer(" + dns + ")");
        String string = dns = dns != null && dns.trim().equals("") ? dns.trim() : IP.ipCheck(dns);
        if (dns != null && EingabenUeberpruefung.isGueltig(dns, EingabenUeberpruefung.musterIpAdresseAuchLeer) && this.getKnoten() instanceof InternetKnoten) {
            InternetKnoten knoten = (InternetKnoten)this.getKnoten();
            ListIterator<NetzwerkInterface> it = knoten.getNetzwerkInterfaces().listIterator();
            while (it.hasNext()) {
                NetzwerkInterface nic = (NetzwerkInterface)it.next();
                nic.setDns(dns);
            }
        }
    }

    public void setzeNetzmaske(String mask) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (InternetKnotenBetriebssystem), setzeNetzmaske(" + mask + ")");
        mask = IP.ipCheck(mask);
        if (mask != null && EingabenUeberpruefung.isGueltig(mask, EingabenUeberpruefung.musterSubNetz) && this.getKnoten() instanceof InternetKnoten) {
            InternetKnoten knoten = (InternetKnoten)this.getKnoten();
            knoten.getNetzwerkInterfaces().get(0).setSubnetzMaske(mask);
        }
    }

    public String primarySubnetMask() {
        NetzwerkInterface nic = this.primaryNetworkInterface();
        return null == nic ? null : nic.getSubnetzMaske();
    }
}

