/*
 * Decompiled with CFR 0.152.
 */
package filius.software.system;

import filius.hardware.Port;
import filius.hardware.knoten.Switch;
import filius.rahmenprogramm.I18n;
import filius.software.netzzugangsschicht.EthernetFrame;
import filius.software.netzzugangsschicht.SwitchPortBeobachter;
import filius.software.system.SystemSoftware;
import filius.software.system.satEntry;
import java.beans.PropertyChangeEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchFirmware
extends SystemSoftware
implements I18n {
    private static Logger LOG = LoggerFactory.getLogger(SwitchFirmware.class);
    private static final long serialVersionUID = 1L;
    private ConcurrentHashMap<String, satEntry> sat = new ConcurrentHashMap();
    private LinkedList<SwitchPortBeobachter> switchBeobachter;
    private LinkedList<EthernetFrame> durchgelaufeneFrames = new LinkedList();
    private String ssid = UUID.randomUUID().toString().substring(0, 6);
    private long retentionTime = 300000L;

    public long getRetentionTime() {
        return this.retentionTime;
    }

    public void setRetentionTime(long retentionTime) {
        this.retentionTime = retentionTime;
    }

    @Override
    public void starten() {
        super.starten();
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (SwitchFirmware), starten()");
        this.sat = new ConcurrentHashMap();
        this.switchBeobachter = new LinkedList();
        for (Port anschluss : ((Switch)this.getKnoten()).getAnschluesse()) {
            SwitchPortBeobachter anschlussBeobachter = new SwitchPortBeobachter(this, anschluss);
            anschlussBeobachter.starten();
            this.switchBeobachter.add(anschlussBeobachter);
        }
        this.firePropertyChanged(new PropertyChangeEvent(this, "sat_entry", null, null));
        final Timer timer = new Timer();
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (!SwitchFirmware.this.isStarted()) {
                    timer.cancel();
                } else if (!SwitchFirmware.this.sat.isEmpty()) {
                    SwitchFirmware.this.checkSAT();
                }
            }
        }, 1000L, 1000L);
    }

    @Override
    public void beenden() {
        super.beenden();
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (SwitchFirmware), beenden()");
        for (SwitchPortBeobachter anschlussBeobachter : this.switchBeobachter) {
            anschlussBeobachter.beenden();
        }
    }

    public Vector<Vector<String>> holeSAT() {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (SwitchFirmware), holeSAT()");
        Vector<Vector<String>> eintraege = new Vector<Vector<String>>();
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
        for (String elem : this.sat.keySet()) {
            Port anschluss = this.sat.get(elem).getPort();
            String ausgabe = messages.getString("sw_switchfirmware_msg1") + " " + (((Switch)this.getKnoten()).getAnschluesse().indexOf(anschluss) + 1);
            Vector<Object> eintrag = new Vector<Object>();
            eintrag.add(elem.toUpperCase());
            eintrag.add(ausgabe);
            eintrag.add(formatter.format(this.sat.get(elem).holeLetztesUpdate()));
            eintraege.add(eintrag);
        }
        return eintraege;
    }

    public void hinzuSatEintrag(String macAdresse, Port anschluss, Date letztes_Update) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (SwitchFirmware), hinzuSatEintrag(" + macAdresse + "," + String.valueOf(anschluss) + "," + String.valueOf(letztes_Update) + ")");
        satEntry eintrag = new satEntry();
        eintrag.setPort(anschluss);
        eintrag.hinzuLetztesUpdate(letztes_Update);
        this.sat.put(macAdresse, eintrag);
        this.firePropertyChanged(new PropertyChangeEvent(this, "sat_entry", null, anschluss));
    }

    public Port holeAnschlussFuerMAC(String macAdresse) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (SwitchFirmware), holeAnschlussFuerMAC(" + macAdresse + ")");
        if (this.sat.containsKey(macAdresse)) {
            return this.sat.get(macAdresse).getPort();
        }
        return null;
    }

    public LinkedList<EthernetFrame> holeDurchgelaufeneFrames() {
        return this.durchgelaufeneFrames;
    }

    public void setSSID(String ssid) {
        this.ssid = ssid;
    }

    public String getSSID() {
        return this.ssid;
    }

    public void loescheSAT() {
        this.sat.clear();
        this.firePropertyChanged(new PropertyChangeEvent(this, "sat_entry", null, null));
    }

    public void checkSAT() {
        Date jetzt = new Date();
        this.sat.forEach((mac, eintrag) -> {
            if (jetzt.getTime() - eintrag.holeLetztesUpdate().getTime() >= this.getRetentionTime()) {
                this.sat.remove(mac);
                this.firePropertyChanged(new PropertyChangeEvent(this, "sat_entry", null, null));
            }
        });
    }
}

