/*
 * Decompiled with CFR 0.152.
 */
package filius.software.transportschicht;

import filius.exception.ServerSocketException;
import filius.exception.TimeOutException;
import filius.exception.VerbindungsException;
import filius.hardware.NetzwerkInterface;
import filius.rahmenprogramm.I18n;
import filius.software.system.InternetKnotenBetriebssystem;
import filius.software.transportschicht.Segment;
import filius.software.transportschicht.Socket;
import filius.software.transportschicht.SocketSchnittstelle;
import filius.software.transportschicht.TCP;
import filius.software.transportschicht.TCPSocket;
import filius.software.transportschicht.TransportProtokoll;
import filius.software.transportschicht.UDPSocket;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerSocket
implements SocketSchnittstelle,
I18n {
    private static Logger LOG = LoggerFactory.getLogger(ServerSocket.class);
    private Hashtable<String, Socket> socketListe = new Hashtable();
    private Socket aktuellerSocket;
    private InternetKnotenBetriebssystem betriebssystem;
    private TransportProtokoll protokoll;
    private int lokalerPort;
    private List<NetzwerkInterface> boundNICs = Collections.emptyList();

    public ServerSocket(InternetKnotenBetriebssystem betriebssystem, int lokalerPort, int transportProtokoll, List<NetzwerkInterface> bind) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (ServerSocket), constr: ServerSocket(" + String.valueOf(betriebssystem) + "," + lokalerPort + "," + transportProtokoll + ")");
        this.betriebssystem = betriebssystem;
        this.lokalerPort = lokalerPort;
        this.boundNICs = bind;
        this.protokoll = transportProtokoll == 6 ? betriebssystem.holeTcp() : betriebssystem.holeUdp();
    }

    public int getLocalPort() {
        return this.lokalerPort;
    }

    public Hashtable<String, Socket> getSockets() {
        return this.socketListe;
    }

    public void eintragenSocket(Socket socket) {
        String ziel = socket.holeZielIPAdresse() + ":" + socket.holeZielPort();
        this.socketListe.put(ziel, socket);
        LOG.debug("[port={}] socket for remote client {} added.", (Object)this.lokalerPort, (Object)ziel);
    }

    public void austragenSocket(Socket socket) {
        String ziel = socket.holeZielIPAdresse() + ":" + socket.holeZielPort();
        this.socketListe.remove(ziel);
        LOG.debug("[port={}] socket for remote client {} removed.", (Object)this.lokalerPort, (Object)ziel);
        if (this.socketListe.isEmpty() && this.aktuellerSocket == null) {
            this.protokoll.gibPortFrei(this.lokalerPort);
        }
    }

    public synchronized Socket oeffnen() throws VerbindungsException, ServerSocketException {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (ServerSocket), oeffnen()");
        if (!this.protokoll.reservierePort(this.lokalerPort, this)) {
            throw new ServerSocketException(messages.getString("sw_serversocket_msg1") + " " + this.lokalerPort + " " + messages.getString("sw_serversocket_msg2"));
        }
        this.aktuellerSocket = this.protokoll instanceof TCP ? new TCPSocket(this.betriebssystem, this.lokalerPort) : new UDPSocket(this.betriebssystem, this.lokalerPort);
        try {
            this.aktuellerSocket.verbinden();
        }
        catch (TimeOutException e) {
            this.aktuellerSocket = null;
            LOG.debug("[port={}] unexpected timeout exception while listening for incoming connection.", (Object)this.lokalerPort, (Object)e);
        }
        if (this.aktuellerSocket != null && this.aktuellerSocket.istVerbunden()) {
            return this.aktuellerSocket;
        }
        return null;
    }

    @Override
    public void hinzufuegen(String startIp, int startPort, Segment segment) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (ServerSocket), hinzufuegen(" + startIp + "," + startPort + "," + String.valueOf(segment) + ")");
        boolean isForBoundIPAddress = this.boundNICs.isEmpty();
        for (NetzwerkInterface netzwerkInterface : this.boundNICs) {
            if (!segment.getRcvNic().getIp().equals(netzwerkInterface.getIp())) continue;
            isForBoundIPAddress = true;
        }
        String start = startIp + ":" + startPort;
        if (!isForBoundIPAddress) {
            LOG.debug("discard segment '{}' since it is not for bound ip address of this socket '{}'", (Object)segment, (Object)this.boundNICs);
        } else if (this.socketListe.containsKey(start)) {
            Socket socket = this.socketListe.get(start);
            socket.hinzufuegen(startIp, startPort, segment);
        } else if (this.aktuellerSocket != null) {
            this.aktuellerSocket.hinzufuegen(startIp, startPort, segment);
        }
    }

    @Override
    public void schliessen() {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (ServerSocket), schliessen()");
        if (this.aktuellerSocket != null) {
            this.aktuellerSocket.schliessen();
            this.protokoll.gibPortFrei(this.lokalerPort);
        }
    }

    @Override
    public void beenden() {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (ServerSocket), beenden()");
        if (this.aktuellerSocket != null) {
            this.aktuellerSocket.beenden();
        }
    }
}

