/*
 * Decompiled with CFR 0.152.
 */
package filius.software.transportschicht;

import filius.exception.SocketException;
import filius.software.ProtokollThread;
import filius.software.system.InternetKnotenBetriebssystem;
import filius.software.transportschicht.Segment;
import filius.software.transportschicht.SocketSchnittstelle;
import filius.software.transportschicht.TransportProtokoll;
import filius.software.vermittlungsschicht.IpPaket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportProtokollThread
extends ProtokollThread<IpPaket> {
    private static Logger LOG = LoggerFactory.getLogger(TransportProtokollThread.class);
    private TransportProtokoll protokoll;

    public TransportProtokollThread(TransportProtokoll protokoll) {
        super(((InternetKnotenBetriebssystem)protokoll.holeSystemSoftware()).holeIP().holePaketListe(protokoll.holeTyp()));
        LOG.trace("INVOKED-2 (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (TransportProtokollThread), constr: TransportProtokollThread(" + String.valueOf(protokoll) + ")");
        this.protokoll = protokoll;
    }

    @Override
    protected void verarbeiteDatenEinheit(IpPaket paket) {
        block2: {
            LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (TransportProtokollThread), verarbeiteDatenEinheit(" + paket.toString() + ")");
            Segment segment = paket.getSegment();
            segment.setRcvNic(paket.getRcvNic());
            try {
                SocketSchnittstelle socket = this.protokoll.holeSocket(segment.getZielPort());
                socket.hinzufuegen(paket.getSender(), segment.getQuellPort(), segment);
            }
            catch (SocketException e) {
                if (paket.getEmpfaenger().equals("255.255.255.255") || paket.getEmpfaenger().equals("0.0.0.0")) break block2;
                LOG.debug("", e);
            }
        }
    }
}

