/*
 * Decompiled with CFR 0.152.
 */
package filius.software.vermittlungsschicht;

import filius.hardware.NetzwerkInterface;
import filius.hardware.Verbindung;
import filius.hardware.knoten.InternetKnoten;
import filius.software.system.InternetKnotenBetriebssystem;
import filius.software.system.SystemSoftware;
import filius.software.vermittlungsschicht.ARPThread;
import filius.software.vermittlungsschicht.ArpPaket;
import filius.software.vermittlungsschicht.IP;
import filius.software.vermittlungsschicht.VermittlungsProtokoll;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ARP
extends VermittlungsProtokoll {
    private static Logger LOG = LoggerFactory.getLogger(ARP.class);
    private HashMap<String, String[]> arpTabelle = new HashMap();
    private ARPThread thread;

    public ARP(SystemSoftware systemAnwendung) {
        super(systemAnwendung);
        LOG.trace("INVOKED-2 (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (ARP), constr: ARP(" + String.valueOf(systemAnwendung) + ")");
    }

    @Override
    public void starten() {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (ARP), starten()");
        this.resetArpTable();
        this.thread = new ARPThread(this);
        this.thread.starten();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetArpTable() {
        HashMap<String, String[]> hashMap = this.arpTabelle;
        synchronized (hashMap) {
            this.arpTabelle = new HashMap();
            this.hinzuARPTabellenEintrag("255.255.255.255", "FF:FF:FF:FF:FF:FF");
        }
    }

    @Override
    public void beenden() {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (ARP), beenden()");
        if (this.thread != null) {
            this.thread.beenden();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hinzuARPTabellenEintrag(String ipAdresse, String macAdresse) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (ARP), hinzuARPTabellenEintrag(" + ipAdresse + "," + macAdresse + ")");
        String tmpTime = "" + System.currentTimeMillis();
        String[] tmpString = new String[]{macAdresse, tmpTime};
        HashMap<String, String[]> hashMap = this.arpTabelle;
        synchronized (hashMap) {
            this.arpTabelle.put(ipAdresse, tmpString);
            this.arpTabelle.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeARPTableEntry(String ipAddress) {
        HashMap<String, String[]> hashMap = this.arpTabelle;
        synchronized (hashMap) {
            this.arpTabelle.remove(ipAddress);
            this.arpTabelle.notify();
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String[]> entry : this.arpTabelle.entrySet()) {
            builder.append("\t").append(entry.getKey()).append(" \t ").append(entry.getValue()[0]).append("\n");
        }
        return builder.toString();
    }

    public Map<String, String> holeARPTabelle(String address) {
        HashMap<String, String> table = new HashMap<String, String>();
        String[] entry = this.arpTabelle.get(address);
        if (null != entry) {
            table.put(address, entry[0]);
        }
        return table;
    }

    public Map<String, String> holeARPTabelle() {
        HashMap<String, String> table = new HashMap<String, String>();
        for (String ipAddress : this.arpTabelle.keySet()) {
            table.put(ipAddress, this.arpTabelle.get(ipAddress)[0]);
        }
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String holeARPTabellenEintrag(String zielIp, int maxRetries, boolean selectNicByAddress) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (ARP), holeARPTabellenEintrag(" + zielIp + ")");
        if (zielIp.equals("127.0.0.1")) {
            return ((InternetKnotenBetriebssystem)this.holeSystemSoftware()).primaryMACAddress();
        }
        if (this.holeSystemSoftware() instanceof InternetKnotenBetriebssystem && zielIp.equals(((InternetKnotenBetriebssystem)this.holeSystemSoftware()).primaryIPAdresse())) {
            return ((InternetKnotenBetriebssystem)this.holeSystemSoftware()).primaryMACAddress();
        }
        String[] arpEntry = this.arpTabelle.get(zielIp);
        if (arpEntry != null) {
            return arpEntry[0];
        }
        for (int i = 0; arpEntry == null && i < maxRetries; ++i) {
            if (!this.sendeARPBroadcast(zielIp, selectNicByAddress)) {
                LOG.debug("No ARP request sent. No applicable NIC.");
            } else {
                LOG.debug("Send ARP query for " + (i + 1) + ". time.");
                HashMap<String, String[]> hashMap = this.arpTabelle;
                synchronized (hashMap) {
                    try {
                        this.arpTabelle.wait(Verbindung.holeRTT());
                    }
                    catch (InterruptedException e) {
                        LOG.debug("EXCEPTION (" + this.hashCode() + "): keine Anwort auf ARP-Broadcast fuer IP-Adresse " + zielIp + " eingegangen!", e);
                    }
                }
            }
            arpEntry = this.arpTabelle.get(zielIp);
        }
        if (arpEntry != null) {
            return arpEntry[0];
        }
        LOG.info("kein ARP-Tabellen-Eintrag fuer " + zielIp);
        return null;
    }

    private boolean sendeARPBroadcast(String suchIp, boolean selectNicByAddress) {
        NetzwerkInterface nic = selectNicByAddress ? this.getBroadcastNic(suchIp) : this.getDefaultNic();
        boolean requestSent = false;
        if (nic != null) {
            this.sendArpRequest(nic.getMac(), nic.getIp(), "FF:FF:FF:FF:FF:FF", suchIp, null);
            requestSent = true;
        }
        return requestSent;
    }

    public ArpPaket sendArpRequest(String senderMAC, String senderIP, String targetMAC, String lookupOrTargetIP, NetzwerkInterface useNic) {
        ArpPaket arpPaket = new ArpPaket();
        arpPaket.setOperation(ArpPaket.REQUEST);
        arpPaket.setProtokollTyp("0x800");
        arpPaket.setTargetIP(lookupOrTargetIP);
        arpPaket.setTargetMAC(targetMAC);
        arpPaket.setSenderIP(senderIP);
        arpPaket.setSenderMAC(senderMAC);
        ((InternetKnotenBetriebssystem)this.holeSystemSoftware()).holeEthernet().senden(arpPaket, senderMAC, arpPaket.getTargetMAC(), "0x806", null);
        return arpPaket;
    }

    public ArpPaket sendArpReply(String senderMAC, String senderIP, String targetMAC, String targetIP, NetzwerkInterface useNic) {
        ArpPaket antwortArp = new ArpPaket();
        antwortArp.setOperation(ArpPaket.REPLY);
        antwortArp.setProtokollTyp("0x800");
        antwortArp.setSenderIP(senderIP);
        antwortArp.setSenderMAC(senderMAC);
        if (targetIP.equalsIgnoreCase("0.0.0.0")) {
            antwortArp.setTargetIP("255.255.255.255");
            antwortArp.setTargetMAC("ff:ff:ff:ff:ff:ff");
        } else {
            antwortArp.setTargetIP(targetIP);
            antwortArp.setTargetMAC(targetMAC);
        }
        ((InternetKnotenBetriebssystem)this.holeSystemSoftware()).holeEthernet().senden(antwortArp, senderMAC, antwortArp.getTargetMAC(), "0x806", useNic);
        return antwortArp;
    }

    NetzwerkInterface getBroadcastNic(String zielStr) {
        long zielAddr = IP.inetAton(zielStr);
        long bestMask = -1L;
        NetzwerkInterface bestNic = null;
        for (NetzwerkInterface nic : ((InternetKnoten)this.holeSystemSoftware().getKnoten()).getNetzwerkInterfaces()) {
            long netAddr;
            long maskAddr = IP.inetAton(nic.getSubnetzMaske());
            if (maskAddr <= bestMask || (netAddr = IP.inetAton(nic.getIp()) & maskAddr) != (maskAddr & zielAddr)) continue;
            bestMask = maskAddr;
            bestNic = nic;
        }
        return bestNic;
    }

    NetzwerkInterface getDefaultNic() {
        return ((InternetKnoten)this.holeSystemSoftware().getKnoten()).getNetzwerkInterfaces().get(0);
    }

    public ARPThread getARPThread() {
        return this.thread;
    }
}

