/*
 * Decompiled with CFR 0.152.
 */
package filius.software.vermittlungsschicht;

import filius.hardware.NetzwerkInterface;
import filius.software.ProtokollThread;
import filius.software.system.InternetKnotenBetriebssystem;
import filius.software.vermittlungsschicht.ARP;
import filius.software.vermittlungsschicht.ArpPaket;
import filius.software.vermittlungsschicht.VermittlungsProtokoll;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ARPThread
extends ProtokollThread<ArpPaket> {
    private static Logger LOG = LoggerFactory.getLogger(ARPThread.class);
    private ARP vermittlung;

    public ARPThread(ARP vermittlung) {
        super(((InternetKnotenBetriebssystem)vermittlung.holeSystemSoftware()).holeEthernet().holeARPPuffer());
        LOG.trace("INVOKED-2 (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (ARPThread), constr: ARPThread(" + String.valueOf(vermittlung) + ")");
        this.vermittlung = vermittlung;
    }

    @Override
    protected void verarbeiteDatenEinheit(ArpPaket arpPaket) {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (ARPThread), verarbeiteDatenEinheit(" + arpPaket.toString() + ")");
        InternetKnotenBetriebssystem bs = (InternetKnotenBetriebssystem)this.vermittlung.holeSystemSoftware();
        NetzwerkInterface nic = arpPaket.getRcvNic();
        if (nic != null && !VermittlungsProtokoll.getSubnetForIp(nic.getIp(), nic.getSubnetzMaske()).equals(arpPaket.getSenderIP())) {
            if (arpPaket.getTargetIP().equals(nic.getIp()) || arpPaket.getOperation() == ArpPaket.REPLY && !arpPaket.getSenderIP().equalsIgnoreCase("0.0.0.0")) {
                LOG.debug("ARP data received, will insert data for sender: {}", (Object)arpPaket);
                this.vermittlung.hinzuARPTabellenEintrag(arpPaket.getSenderIP(), arpPaket.getSenderMAC());
            }
            if (arpPaket.getTargetMAC().equalsIgnoreCase("ff:ff:ff:ff:ff:ff") && arpPaket.getTargetIP().equalsIgnoreCase(nic.getIp())) {
                bs.holeARP().sendArpReply(nic.getMac(), nic.getIp(), arpPaket.getSenderMAC(), arpPaket.getSenderIP(), nic);
            } else {
                LOG.debug("ARP: do not respond on NIC '{}' for ARP request ({})", (Object)nic.getIp(), (Object)arpPaket);
            }
        } else {
            LOG.debug("ARP packet discarded ({})", (Object)arpPaket);
        }
    }
}

