/*
 * Decompiled with CFR 0.152.
 */
package filius.software.vermittlungsschicht;

import filius.hardware.NetzwerkInterface;
import filius.hardware.knoten.InternetKnoten;
import filius.rahmenprogramm.I18n;
import filius.software.system.InternetKnotenBetriebssystem;
import filius.software.system.SystemSoftware;
import filius.software.vermittlungsschicht.ICMPThread;
import filius.software.vermittlungsschicht.IcmpPaket;
import filius.software.vermittlungsschicht.Route;
import filius.software.vermittlungsschicht.RouteNotFoundException;
import filius.software.vermittlungsschicht.VermittlungsProtokoll;
import java.util.LinkedList;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ICMP
extends VermittlungsProtokoll
implements I18n {
    private static Logger LOG = LoggerFactory.getLogger(ICMP.class);
    public static final int TYPE_ECHO_REPLY = 0;
    public static final int TYPE_ECHO_REQUEST = 8;
    public static final int TYPE_DESTINATION_UNREACHABLE = 3;
    public static final int TYPE_TIME_EXCEEDED = 11;
    public static final int CODE_ECHO = 0;
    public static final int CODE_DEST_NETWORK_UNREACHABLE = 0;
    public static final int CODE_DEST_HOST_UNREACHABLE = 1;
    public static final int CODE_TTL_EXPIRED = 0;
    private ICMPThread thread;

    public ICMP(SystemSoftware systemAnwendung) {
        super(systemAnwendung);
        LOG.debug("INVOKED-2 (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (ICMP), constr: ICMP(" + String.valueOf(systemAnwendung) + ")");
    }

    @Override
    public void starten() {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (ICMP), starten()");
        this.thread = new ICMPThread(this);
        this.thread.starten();
    }

    @Override
    public void beenden() {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (ICMP), beenden()");
        if (this.thread != null) {
            this.thread.beenden();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void placeLocalICMPPacket(IcmpPaket icmpPacket) {
        LinkedList<IcmpPaket> icmpPakete;
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (ICMP), placeLocalICMPPacket(" + icmpPacket.toString() + ")");
        LinkedList<IcmpPaket> linkedList = icmpPakete = ((InternetKnotenBetriebssystem)this.holeSystemSoftware()).holeEthernet().holeICMPPuffer();
        synchronized (linkedList) {
            icmpPakete.add(icmpPacket);
            icmpPakete.notify();
        }
    }

    public void sendEchoRequest(String destIp, int seqNr) {
        this.sendeICMP(8, 0, seqNr, null, destIp);
    }

    public void sendEchoReply(IcmpPaket rcvPacket) {
        this.sendeICMP(0, 0, rcvPacket.getSeqNr(), null, rcvPacket.getSender());
    }

    public void sendeICMP(int typ, int code, String zielIP) {
        this.sendeICMP(typ, code, 0, null, zielIP);
    }

    public void sendeICMP(int typ, int code, int seqNr, String quellIP, String zielIP) {
        this.sendeICMP(typ, code, 64, seqNr, -1L, quellIP, zielIP);
    }

    private void sendeICMP(int typ, int code, int ttl, int seqNr, long identification, String quellIP, String zielIP) {
        block4: {
            IcmpPaket icmpPaket = new IcmpPaket(identification);
            icmpPaket.setEmpfaenger(zielIP);
            icmpPaket.setIcmpType(typ);
            icmpPaket.setIcmpCode(code);
            icmpPaket.setSeqNr(seqNr);
            icmpPaket.setTtl(ttl);
            try {
                InternetKnotenBetriebssystem bs = (InternetKnotenBetriebssystem)this.holeSystemSoftware();
                Route route = bs.determineRoute(zielIP);
                if (quellIP == null) {
                    icmpPaket.setSender(route.getInterfaceIpAddress());
                } else {
                    icmpPaket.setSender(quellIP);
                }
                this.dispatch(icmpPaket, zielIP, route);
            }
            catch (RouteNotFoundException e) {
                if (!icmpPaket.isEchoRequest()) break block4;
                this.sendeICMP(3, 0, seqNr, null, quellIP);
            }
        }
    }

    private void dispatch(IcmpPaket paket, String zielIp, Route route) throws RouteNotFoundException {
        NetzwerkInterface nic = ((InternetKnoten)this.holeSystemSoftware().getKnoten()).getNetzwerkInterfaceByIp(route.getInterfaceIpAddress());
        if (ICMP.isBroadcast(zielIp, route.getInterfaceIpAddress(), nic.getSubnetzMaske())) {
            this.sendBroadcast(paket, zielIp, nic.getMac(), nic);
        } else if (ICMP.gleichesRechnernetz(zielIp, route.getInterfaceIpAddress(), nic.getSubnetzMaske())) {
            this.sendUnicastToNextHop(paket, paket.getEmpfaenger(), nic.getMac(), nic);
        } else {
            this.sendUnicastToNextHop(paket, route.getGateway(), nic.getMac(), nic);
        }
    }

    private void sendUnicastToNextHop(IcmpPaket paket, String ziel, String macOfNicToUse, NetzwerkInterface useNic) {
        InternetKnotenBetriebssystem bs = (InternetKnotenBetriebssystem)this.holeSystemSoftware();
        String zielMacAdresse = bs.holeARP().holeARPTabellenEintrag(ziel, 2, true);
        if (this.isLocalAddress(ziel)) {
            this.placeLocalICMPPacket(paket);
        } else if (zielMacAdresse != null) {
            bs.holeEthernet().senden(paket, macOfNicToUse, zielMacAdresse, "0x800", useNic);
        } else if (paket.isEchoRequest()) {
            this.sendeICMP(3, 1, paket.getSeqNr(), null, paket.getSender());
        }
    }

    private void sendBroadcast(IcmpPaket paket, String ziel, String macOfNicToUse, NetzwerkInterface useNic) {
        paket.setTtl(1);
        InternetKnotenBetriebssystem bs = (InternetKnotenBetriebssystem)this.holeSystemSoftware();
        bs.holeEthernet().senden(paket, macOfNicToUse, "FF:FF:FF:FF:FF:FF", "0x800", useNic);
    }

    public void weiterleitenPaket(IcmpPaket icmpPaket) {
        if (icmpPaket.getTtl() <= 1) {
            this.sendeTimeExceededReply(icmpPaket.getSender(), icmpPaket.getSeqNr());
        } else {
            this.sendeICMP(icmpPaket.getIcmpType(), icmpPaket.getIcmpCode(), icmpPaket.getTtl() - 1, icmpPaket.getSeqNr(), icmpPaket.getIdentification(), icmpPaket.getSender(), icmpPaket.getEmpfaenger());
        }
    }

    public void sendeTimeExceededReply(String replyRecipient, int seqNo) {
        this.sendeICMP(11, 0, seqNo, null, replyRecipient);
    }

    public IcmpPaket startSinglePing(String destIp, int seqNr) throws TimeoutException {
        this.thread.resetIcmpResponseQueue();
        this.sendEchoRequest(destIp, seqNr);
        IcmpPaket response = this.thread.waitForIcmpResponse();
        if (response == null) {
            throw new TimeoutException("Destination Host Unreachable");
        }
        if (seqNr != response.getSeqNr() || !response.isEchoResponse()) {
            throw new TimeoutException("Destination Host Unreachable");
        }
        return response;
    }

    public IcmpPaket sendProbe(String destIp, int ttl, int seqNr) {
        this.thread.resetIcmpResponseQueue();
        this.sendeICMP(8, 0, ttl, seqNr, -1L, null, destIp);
        return this.thread.waitForIcmpResponse();
    }

    public ICMPThread getICMPThread() {
        return this.thread;
    }
}

