/*
 * Decompiled with CFR 0.152.
 */
package filius.software.vermittlungsschicht;

import filius.software.vermittlungsschicht.IpPaket;

public class IcmpPaket
extends IpPaket {
    public static final int ICMP_PROTOCOL = 1;
    private int seqNr;
    private int icmpType;
    private int icmpCode;

    public IcmpPaket(long identification) {
        super(1, identification);
    }

    @Override
    public IcmpPaket clone() {
        IcmpPaket clone = new IcmpPaket(this.getIdentification());
        this.copyIpPacketAttributes(clone);
        this.copyIcmpAttributes(clone);
        return clone;
    }

    private void copyIcmpAttributes(IcmpPaket clone) {
        clone.seqNr = this.seqNr;
        clone.icmpType = this.icmpType;
        clone.icmpCode = this.icmpCode;
    }

    public void setIcmpType(int type) {
        this.icmpType = type;
    }

    public void setIcmpCode(int code) {
        this.icmpCode = code;
    }

    public int getIcmpType() {
        return this.icmpType;
    }

    public int getIcmpCode() {
        return this.icmpCode;
    }

    public boolean isEchoResponse() {
        return this.icmpType == 0 && this.icmpCode == 0;
    }

    public boolean isEchoRequest() {
        return this.icmpType == 8 && this.icmpCode == 0;
    }

    public int getSeqNr() {
        return this.seqNr;
    }

    public void setSeqNr(int seqNr) {
        this.seqNr = seqNr;
    }

    @Override
    public String toString() {
        return "[sender=" + this.getSender() + "; recipient=" + this.getEmpfaenger() + "; ttl=" + this.getTtl() + "; seqNr=" + this.seqNr + "; icmpType=" + this.icmpType + "; icmpCode=" + this.icmpCode + ", identification=" + this.getIdentification() + "]";
    }
}

