/*
 * Decompiled with CFR 0.152.
 */
package filius.software.vermittlungsschicht;

import filius.software.ProtocolDataUnit;
import filius.software.transportschicht.Segment;

public class IpPaket
extends ProtocolDataUnit
implements Cloneable {
    public static final int UDP = 17;
    public static final int TCP = 6;
    private static long identificationCounter;
    private String sender;
    private String empfaenger;
    private int ttl;
    private final int protocol;
    private final long identification;
    private Segment data;

    public IpPaket(int protocol, long identification) {
        this.protocol = protocol;
        this.identification = identification < 0L ? IpPaket.getNextIdentCounter() : identification;
    }

    private static synchronized long getNextIdentCounter() {
        return ++identificationCounter;
    }

    public IpPaket clone() {
        IpPaket clone = new IpPaket(this.protocol, this.identification);
        clone.setRcvNic(this.getRcvNic());
        this.copyIpPacketAttributes(clone);
        return clone;
    }

    void copyIpPacketAttributes(IpPaket clone) {
        clone.ttl = this.ttl;
        clone.empfaenger = this.empfaenger;
        clone.sender = this.sender;
        clone.data = this.data;
    }

    public String getEmpfaenger() {
        return this.empfaenger;
    }

    public void setEmpfaenger(String empfaenger) {
        this.empfaenger = empfaenger;
    }

    public String getSender() {
        return this.sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public int getProtocol() {
        return this.protocol;
    }

    public int getTtl() {
        return this.ttl;
    }

    public void setTtl(int ttl) {
        this.ttl = ttl;
    }

    public long getIdentification() {
        return this.identification;
    }

    public Segment getSegment() {
        return this.data;
    }

    public void setSegment(Segment data) {
        this.data = data;
    }

    public String toString() {
        return "[ttl=" + this.ttl + ", protocol=" + this.protocol + ", empfaenger=" + this.empfaenger + ", sender=" + this.sender + ", identification=" + this.identification + "]";
    }

    public void decrementTtl() {
        --this.ttl;
    }
}

