/*
 * Decompiled with CFR 0.152.
 */
package filius.software.www;

import filius.rahmenprogramm.I18n;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriUtils;

public class HTTPNachricht
implements I18n {
    private static Logger LOG = LoggerFactory.getLogger(HTTPNachricht.class);
    public static final int SERVER = 0;
    public static final int CLIENT = 1;
    public static final String GET = "GET";
    public static final String POST = "POST";
    public static final String TEXT_HTML = "text/html";
    public static final String IMAGE_PNG = "image/png";
    public static final String IMAGE_BMP = "image/bmp";
    public static final String IMAGE_GIF = "image/gif";
    public static final String IMAGE_JPG = "image/jpg";
    public static final String TEXT_PLAIN = "text/plain";
    private String contentType;
    private String host;
    private String protocolVersion;
    private String method;
    private int statusCode;
    private int mode;
    private StringBuffer daten;
    private String pfad;

    public HTTPNachricht(int mode) {
        this.contentType = null;
        this.host = null;
        this.protocolVersion = "HTTP/1.1";
        this.method = null;
        this.statusCode = 0;
        this.mode = 1;
        this.daten = null;
        this.pfad = null;
        this.mode = mode;
    }

    public HTTPNachricht(String nachricht) {
        block8: {
            StringTokenizer tokenizer;
            this.contentType = null;
            this.host = null;
            this.protocolVersion = "HTTP/1.1";
            this.method = null;
            this.statusCode = 0;
            this.mode = 1;
            this.daten = null;
            this.pfad = null;
            LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (HTTPNachricht), constr: HTTPNachricht(" + nachricht + ")");
            String[] zeilen = nachricht.split("\n");
            if (zeilen.length <= 0 || !(tokenizer = new StringTokenizer(zeilen[0], " ")).hasMoreTokens()) break block8;
            String token = tokenizer.nextToken().trim();
            if (token.equalsIgnoreCase(GET) || token.equalsIgnoreCase(POST)) {
                this.method = token;
                token = tokenizer.nextToken().trim();
                this.pfad = HTTPNachricht.decodePath(token);
                this.protocolVersion = token = tokenizer.nextToken().trim();
                for (int i = 1; i < zeilen.length; ++i) {
                    if (zeilen[i].equals("") && this.method.equalsIgnoreCase(POST)) {
                        this.daten = new StringBuffer();
                        for (int j = i; j < zeilen.length; ++j) {
                            this.daten.append(zeilen[j]);
                            if (j >= zeilen.length - 1) continue;
                            this.daten.append("\n");
                        }
                        i = zeilen.length;
                        continue;
                    }
                    tokenizer = new StringTokenizer(zeilen[i], " ");
                    token = tokenizer.nextToken().trim();
                    if (!token.equalsIgnoreCase("host:")) continue;
                    this.host = tokenizer.nextToken().trim();
                }
            } else {
                this.protocolVersion = token;
                token = tokenizer.nextToken().trim();
                this.statusCode = Integer.parseInt(token);
                for (int i = 1; i < zeilen.length; ++i) {
                    if (zeilen[i].equals("")) {
                        this.daten = new StringBuffer();
                        for (int j = i + 1; j < zeilen.length; ++j) {
                            this.daten.append(zeilen[j]);
                            if (j >= zeilen.length - 1) continue;
                            this.daten.append("\n");
                        }
                        i = zeilen.length;
                        continue;
                    }
                    tokenizer = new StringTokenizer(zeilen[i], " ");
                    token = tokenizer.nextToken().trim();
                    if (!token.equalsIgnoreCase("content-type:")) continue;
                    this.contentType = tokenizer.nextToken().trim();
                }
            }
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.mode == 1 && this.method != null && this.pfad != null && this.protocolVersion != null) {
            buffer.append(this.method + " " + HTTPNachricht.encodePath(this.getPfad()) + " " + this.protocolVersion + "\n");
            if (this.host != null) {
                buffer.append("Host: " + this.host + "\n");
            }
            if (this.method.equals(POST) && this.daten != null) {
                buffer.append("\n" + String.valueOf(this.daten));
            }
        } else if (this.mode == 0 && this.protocolVersion != null) {
            buffer.append(this.protocolVersion + " " + this.statusCode + " " + HTTPNachricht.holeStatusNachricht(this.statusCode) + "\n");
            if (this.contentType != null) {
                buffer.append("Content-type: " + this.contentType + "\n");
            }
            if (this.daten != null) {
                buffer.append("\n" + String.valueOf(this.daten));
            }
        }
        return buffer.toString();
    }

    public static String holeStatusNachricht(int code) {
        LOG.trace("INVOKED (static) filius.software.www.HTTPNachricht, holeStatusNachricht(" + code + ")");
        if (code == 100) {
            return "Continue";
        }
        if (code == 101) {
            return "Switching Protocols";
        }
        if (code == 102) {
            return "Processing";
        }
        if (code == 200) {
            return "OK";
        }
        if (code == 201) {
            return "Created";
        }
        if (code == 202) {
            return "Accepted";
        }
        if (code == 203) {
            return "Non-Authoritative Information";
        }
        if (code == 204) {
            return "No Content";
        }
        if (code == 205) {
            return "Reset Content";
        }
        if (code == 206) {
            return "Partial Content";
        }
        if (code == 207) {
            return "Multi-Status";
        }
        if (code == 300) {
            return "Multiple Choice";
        }
        if (code == 301) {
            return "Moved Permanently";
        }
        if (code == 302) {
            return "Found";
        }
        if (code == 303) {
            return "See Other";
        }
        if (code == 304) {
            return "Not Modified";
        }
        if (code == 305) {
            return "Use Proxy";
        }
        if (code == 307) {
            return "Temporary Redirect";
        }
        if (code == 400) {
            return "Bad Request";
        }
        if (code == 401) {
            return "Unauthorized";
        }
        if (code == 402) {
            return "Payment Required";
        }
        if (code == 403) {
            return "Forbidden";
        }
        if (code == 404) {
            return "Not Found";
        }
        if (code == 405) {
            return "Method Not Allowed";
        }
        if (code == 406) {
            return "Not Acceptable";
        }
        if (code == 407) {
            return "Proxy Authentication Required";
        }
        if (code == 408) {
            return "Request Time-out";
        }
        if (code == 409) {
            return "Conflict";
        }
        if (code == 410) {
            return "Gone";
        }
        if (code == 411) {
            return "Length Required";
        }
        if (code == 412) {
            return "Precondition Failed";
        }
        if (code == 413) {
            return "Request Entity Too Large";
        }
        if (code == 414) {
            return "Request-URI Too Long";
        }
        if (code == 415) {
            return "Unsupported Media Type";
        }
        if (code == 416) {
            return "Requested range not satisfiable";
        }
        if (code == 417) {
            return "Expectation Failed";
        }
        if (code == 422) {
            return "Unprocessable Entity";
        }
        if (code == 423) {
            return "Locked";
        }
        if (code == 424) {
            return "Failed Dependency";
        }
        if (code == 500) {
            return "Internal Server Error";
        }
        if (code == 501) {
            return "Not Implemented";
        }
        if (code == 502) {
            return "Bad Gateway";
        }
        if (code == 503) {
            return "Service Unavailable";
        }
        if (code == 504) {
            return "Gateway Time-out";
        }
        if (code == 505) {
            return "HTTP Version not supported";
        }
        if (code == 507) {
            return "Insufficient Storage";
        }
        if (code == 509) {
            return "Bandwidth Limit Exceeded";
        }
        if (code >= 100 && code < 200) {
            return messages.getString("sw_httpnachricht_msg1");
        }
        if (code >= 200 && code < 300) {
            return messages.getString("sw_httpnachricht_msg2");
        }
        if (code >= 300 && code < 400) {
            return messages.getString("sw_httpnachricht_msg3");
        }
        if (code >= 400 && code < 500) {
            return messages.getString("sw_httpnachricht_msg4");
        }
        if (code >= 500 && code < 600) {
            return messages.getString("sw_httpnachricht_msg5");
        }
        return null;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getDaten() {
        if (this.daten == null) {
            return null;
        }
        return this.daten.toString();
    }

    public void setDaten(String data) {
        this.daten = data == null ? null : new StringBuffer(data);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getPfad() {
        if (this.pfad.trim().equals("")) {
            return "/";
        }
        int queryStartIndex = this.pfad.indexOf(63);
        return this.pfad.substring(0, queryStartIndex > 0 ? queryStartIndex : this.pfad.length());
    }

    public void setPfad(String pfad) {
        this.pfad = pfad;
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(String protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    protected static String encodePath(String path) {
        String urlEncodedPath = UriUtils.encodePath(path, "utf8");
        return urlEncodedPath;
    }

    protected static String decodePath(String urlEncodedPath) {
        String path = UriUtils.decode(urlEncodedPath, "utf8");
        return path;
    }
}

