/*
 * Decompiled with CFR 0.152.
 */
package filius.software.www;

import filius.exception.VerbindungsException;
import filius.rahmenprogramm.Base64;
import filius.rahmenprogramm.I18n;
import filius.rahmenprogramm.Information;
import filius.rahmenprogramm.ResourceUtil;
import filius.software.clientserver.ClientAnwendung;
import filius.software.transportschicht.TCPSocket;
import filius.software.www.HTTPNachricht;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.LinkedList;
import org.htmlparser.Node;
import org.htmlparser.Parser;
import org.htmlparser.tags.ImageTag;
import org.htmlparser.visitors.TagFindingVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebBrowser
extends ClientAnwendung
implements I18n {
    private static Logger LOG = LoggerFactory.getLogger(WebBrowser.class);
    private static final int ABRUF_HTML = 1;
    private static final int ABRUF_IMG = 2;
    private LinkedList<String> bilddateien = new LinkedList();
    private String host;

    public void holeWebseite(URL url) {
        this.holeWebseite(url, "");
    }

    public void holeWebseite(URL url, String post) {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (WebBrowser), holeWebseite(" + String.valueOf(url) + "," + post + ")");
        if (this.socket != null) {
            this.ausfuehren("closeConnection", new Object[0]);
        }
        this.ausfuehren("initConnection", new Object[]{url});
        this.ausfuehren("retrieveWebpage", new Object[]{url, post});
        this.ausfuehren("retrieveImages", new Object[0]);
        this.ausfuehren("closeConnection", new Object[0]);
    }

    void initConnection(URL url) {
        HTTPNachricht fehler;
        if (url.getHost() != null && !url.getHost().equals("")) {
            this.host = url.getHost();
        }
        if (this.socket == null) {
            try {
                this.socket = new TCPSocket(this.getSystemSoftware(), this.host, 80);
            }
            catch (VerbindungsException e) {
                fehler = new HTTPNachricht(1);
                fehler.setDaten(this.erzeugeHtmlFehlermeldung(0));
                this.benachrichtigeBeobachter(fehler);
            }
        }
        if (this.socket != null && !this.socket.istVerbunden()) {
            try {
                this.socket.verbinden();
            }
            catch (Exception e) {
                fehler = new HTTPNachricht(1);
                fehler.setDaten(this.erzeugeHtmlFehlermeldung(0));
                this.benachrichtigeBeobachter(fehler);
            }
        }
    }

    void retrieveWebpage(URL url, String post) {
        HTTPNachricht nachricht = this.createRequest(url, post);
        if (this.socket != null && this.socket.istVerbunden()) {
            try {
                String responseData;
                this.socket.senden(nachricht.toString());
                String string = responseData = this.socket != null ? this.socket.empfangen() : null;
                if (responseData == null) {
                    HTTPNachricht response = new HTTPNachricht(1);
                    response.setDaten(this.erzeugeHtmlFehlermeldung(0));
                    this.benachrichtigeBeobachter(response);
                } else {
                    HTTPNachricht response = new HTTPNachricht(responseData);
                    if (response.getStatusCode() != 200) {
                        response.setDaten(this.erzeugeHtmlFehlermeldung(response.getStatusCode()));
                    } else {
                        String contentType = response.getContentType();
                        if ("text/html".equalsIgnoreCase(contentType) && response.getDaten() != null) {
                            this.extractImagesReferences(response.getDaten(), response.getHost());
                        }
                    }
                    this.benachrichtigeBeobachter(response);
                }
            }
            catch (Exception e) {
                LOG.debug("Error while retrieving web page.", e);
            }
        }
    }

    private HTTPNachricht createRequest(URL url, String post) {
        HTTPNachricht nachricht = new HTTPNachricht(1);
        nachricht.setPfad(url.getFile());
        nachricht.setHost(this.host);
        if (nachricht.getHost() != null && !nachricht.getHost().equals("")) {
            if (post != null && !post.equals("")) {
                nachricht.setMethod("POST");
                nachricht.setDaten(post);
            } else {
                nachricht.setMethod("GET");
            }
        }
        return nachricht;
    }

    public String holeHost() {
        return this.host;
    }

    @Override
    public void starten() {
        super.starten();
        this.bilddateien = new LinkedList();
    }

    private String einlesenTextdatei(String datei) throws FileNotFoundException, IOException {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (WebBrowser), einlesenTextdatei(" + datei + ")");
        StringBuffer fullFile = new StringBuffer();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(ResourceUtil.getResourcePath(datei)), Charset.forName("UTF-8")));){
            String input;
            while ((input = reader.readLine()) != null) {
                fullFile.append(input).append("\n");
            }
        }
        return fullFile.toString();
    }

    private String erzeugeHtmlFehlermeldung(int statusCode) {
        String quelltext;
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (WebBrowser), erzeugeHtmlFehlermeldung(" + statusCode + ")");
        if (statusCode == 0) {
            quelltext = messages.getString("sw_webbrowser_msg1");
        } else {
            String dateipfad = ResourceUtil.getResourcePath("tmpl/http_fehler_" + Information.getInformation().getLocaleOrDefault().toString() + ".txt");
            try {
                quelltext = this.einlesenTextdatei(dateipfad);
            }
            catch (Exception e) {
                quelltext = messages.getString("sw_webbrowser_msg2");
                LOG.debug("", e);
            }
            quelltext = quelltext.replace(":code:", "" + statusCode);
            String meldung = HTTPNachricht.holeStatusNachricht(statusCode);
            quelltext = quelltext.replace(":meldung:", meldung);
        }
        return quelltext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractImagesReferences(String quelltext, String host) {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (WebBrowser), verarbeiteIMGTags(" + quelltext + "," + host + ")");
        Parser parser = Parser.createParser(quelltext, null);
        TagFindingVisitor nodeVisitor = new TagFindingVisitor(new String[]{"img"});
        try {
            parser.visitAllNodesWith(nodeVisitor);
            Node[] nodes = nodeVisitor.getTags(0);
            for (int i = 0; i < nodes.length; ++i) {
                if (!(nodes[i] instanceof ImageTag)) continue;
                ImageTag img = (ImageTag)nodes[i];
                LinkedList<String> linkedList = this.bilddateien;
                synchronized (linkedList) {
                    this.bilddateien.add(img.getImageURL());
                    continue;
                }
            }
        }
        catch (Exception e) {
            LOG.debug("", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void retrieveImages() {
        LinkedList<String> linkedList = this.bilddateien;
        synchronized (linkedList) {
            for (String dateipfad : this.bilddateien) {
                try {
                    HTTPNachricht request = this.createRequest(new URL("http", this.host, dateipfad), "");
                    if (this.socket == null || !this.socket.istVerbunden()) continue;
                    this.socket.senden(request.toString());
                    String responseData = this.socket.empfangen();
                    if (responseData == null) continue;
                    HTTPNachricht response = new HTTPNachricht(responseData);
                    if (response.getStatusCode() != 200) {
                        this.benachrichtigeBeobachter();
                        continue;
                    }
                    String contentType = response.getContentType();
                    if (!"image/bmp".equalsIgnoreCase(contentType) && !"image/gif".equalsIgnoreCase(contentType) && !"image/jpg".equalsIgnoreCase(contentType) && !"image/png".equalsIgnoreCase(contentType)) continue;
                    LinkedList<String> linkedList2 = this.bilddateien;
                    synchronized (linkedList2) {
                        if (this.bilddateien.size() > 0) {
                            dateipfad = this.bilddateien.removeFirst();
                            Base64.decodeToFile(response.getDaten(), Information.getInformation().getTempPfad() + dateipfad);
                        }
                    }
                    this.benachrichtigeBeobachter();
                }
                catch (MalformedURLException e) {
                    LOG.debug("Could not retrieve image. Invalid URL.", e);
                }
                catch (Exception e) {
                    LOG.debug("Unexpected error while retrieving images via http.", e);
                }
            }
        }
    }

    void closeConnection() {
        if (this.socket != null) {
            this.socket.schliessen();
            this.socket = null;
        }
    }
}

