/*
 * Decompiled with CFR 0.152.
 */
package filius.software.www;

import filius.software.clientserver.ServerMitarbeiter;
import filius.software.system.Datei;
import filius.software.transportschicht.TCPSocket;
import filius.software.www.HTTPNachricht;
import filius.software.www.WebServer;
import filius.software.www.WebServerPlugIn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebServerMitarbeiter
extends ServerMitarbeiter {
    private static Logger LOG = LoggerFactory.getLogger(WebServerMitarbeiter.class);

    public WebServerMitarbeiter(WebServer server, TCPSocket socket) {
        super(server, socket);
    }

    private HTTPNachricht verarbeiteAnfrage(HTTPNachricht anfrage) {
        WebServerPlugIn plugin;
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (WebServerMitarbeiter), verarbeiteAnfrage(" + String.valueOf(anfrage) + ")");
        String tmp = null;
        HTTPNachricht antwort = new HTTPNachricht(0);
        Object dateipfad = anfrage.getPfad().equals("/") ? "index.html" : (anfrage.getPfad().startsWith("/") ? anfrage.getPfad().substring(1) : anfrage.getPfad());
        Object vHostRelPath = ((WebServer)this.server).vhostPrefix(anfrage.getHost());
        if (!((String)vHostRelPath).endsWith("/")) {
            vHostRelPath = (String)vHostRelPath + "/";
        }
        if (((String)(dateipfad = (String)vHostRelPath + (String)dateipfad)).startsWith("/")) {
            dateipfad = ((String)dateipfad).substring(1);
        }
        if ((plugin = ((WebServer)this.server).holePlugin((String)dateipfad)) != null) {
            tmp = anfrage.getMethod().equals("POST") ? plugin.holeHtmlSeite(anfrage.getDaten()) : plugin.holeHtmlSeite(null);
            if (tmp != null) {
                antwort.setDaten(tmp);
                antwort.setContentType("text/html");
                antwort.setStatusCode(200);
            } else {
                antwort.setStatusCode(500);
            }
        } else {
            Datei datei = ((WebServer)this.server).dateiLiefern((String)dateipfad);
            if (datei != null) {
                antwort.setDaten(datei.getDateiInhalt());
                String filenameLowerCase = datei.getName().toLowerCase();
                if (filenameLowerCase.endsWith("html") || filenameLowerCase.endsWith("htm")) {
                    antwort.setContentType("text/html");
                    antwort.setStatusCode(200);
                } else if (filenameLowerCase.endsWith("png")) {
                    antwort.setContentType("image/png");
                    antwort.setStatusCode(200);
                } else if (filenameLowerCase.endsWith("bmp")) {
                    antwort.setContentType("image/bmp");
                    antwort.setStatusCode(200);
                } else if (filenameLowerCase.endsWith("gif")) {
                    antwort.setContentType("image/gif");
                    antwort.setStatusCode(200);
                } else if (filenameLowerCase.endsWith("jpg")) {
                    antwort.setContentType("image/jpg");
                    antwort.setStatusCode(200);
                } else {
                    antwort.setContentType("text/plain");
                    antwort.setStatusCode(200);
                }
            } else {
                antwort.setStatusCode(404);
            }
        }
        return antwort;
    }

    @Override
    protected void verarbeiteNachricht(String nachricht) {
        HTTPNachricht antwort;
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (WebServerMitarbeiter), verarbeiteNachricht(" + nachricht + ")");
        HTTPNachricht anfrage = new HTTPNachricht(nachricht);
        if (anfrage.getMethod().equals("GET") || anfrage.getMethod().equals("POST")) {
            antwort = this.verarbeiteAnfrage(anfrage);
        } else {
            antwort = new HTTPNachricht(0);
            antwort.setStatusCode(501);
        }
        this.sendeNachricht(antwort.toString());
    }
}

