/*
 * Decompiled with CFR 0.152.
 */
package filius.gui;

import filius.Main;
import filius.gui.JMainFrame;
import filius.rahmenprogramm.I18n;
import filius.rahmenprogramm.ResourceUtil;
import java.awt.Component;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.nio.charset.Charset;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;

public class GUIHilfe
implements I18n {
    private JDialog jf;
    private static GUIHilfe ref = null;
    private JScrollPane spHtmlScroller;
    private JEditorPane epHtml;

    private GUIHilfe() {
        JMainFrame hauptFrame = JMainFrame.getJMainFrame();
        this.jf = new JDialog(hauptFrame, messages.getString("guihilfe_msg1"), false);
        ImageIcon frameIcon = new ImageIcon(this.getClass().getResource("/gfx/allgemein/hilfe.png"));
        this.jf.setIconImage(frameIcon.getImage());
        this.epHtml = new JEditorPane("text/html;charset=UTF-8", null);
        this.epHtml.setText(messages.getString("guihilfe_msg2"));
        this.laden("entwurfsmodus");
        this.spHtmlScroller = new JScrollPane(this.epHtml);
        this.jf.getContentPane().add((Component)this.spHtmlScroller, "Center");
    }

    public static GUIHilfe getGUIHilfe() {
        if (ref == null) {
            ref = new GUIHilfe();
        }
        return ref;
    }

    public void anzeigen() {
        int breite = 350;
        int hoehe = 600;
        int absBreite = (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        int absHoehe = (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        JMainFrame hauptFrame = JMainFrame.getJMainFrame();
        int x = hauptFrame.getX() + hauptFrame.getWidth();
        int y = hauptFrame.getY();
        if (y + hoehe > absHoehe) {
            y = 0;
        }
        if (x + breite > absBreite && x + breite - 50 < absBreite) {
            breite = absBreite - x;
        } else if (x + breite > absBreite) {
            x = absBreite - (breite -= 50);
        }
        this.jf.setBounds(x, y, breite, hoehe);
        this.jf.setVisible(true);
    }

    public void laden(String modus) {
        File file = modus.equalsIgnoreCase("entwurfsmodus") ? ResourceUtil.getResourceFile("hilfe/" + messages.getString("hilfedatei_entwurf")) : ResourceUtil.getResourceFile("hilfe/" + messages.getString("hilfedatei_simulation"));
        String gfxPath = "file:" + file.getParentFile().getAbsolutePath() + "/gfx/";
        if (File.separator.equals("\\")) {
            gfxPath = gfxPath.replace('\\', '/');
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName("UTF-8")));){
            StringBuffer sb = new StringBuffer();
            String line = reader.readLine();
            while (line != null) {
                sb.append(line);
                line = reader.readLine();
            }
            String newText = sb.toString();
            newText = newText.replaceAll("hilfe/gfx/", gfxPath);
            System.out.println(newText);
            this.epHtml.read(new StringReader(newText), null);
            this.epHtml.setCaretPosition(0);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace(Main.debug);
        }
        catch (IOException e) {
            e.printStackTrace(Main.debug);
        }
    }
}

