/*
 * Decompiled with CFR 0.152.
 */
package filius.gui;

import filius.Main;
import filius.gui.GUIContainer;
import filius.gui.GUIHilfe;
import filius.gui.InfoDialog;
import filius.gui.JBackgroundPanel;
import filius.gui.JMainFrame;
import filius.gui.netzwerksicht.GUIKabelItem;
import filius.gui.netzwerksicht.GUIKnotenItem;
import filius.gui.netzwerksicht.JVermittlungsrechnerKonfiguration;
import filius.gui.quelltextsicht.FrameSoftwareWizard;
import filius.hardware.Verbindung;
import filius.rahmenprogramm.I18n;
import filius.rahmenprogramm.Information;
import filius.rahmenprogramm.SzenarioVerwaltung;
import filius.software.system.SystemSoftware;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import javax.tools.ToolProvider;

public class GUIMainMenu
implements Serializable,
I18n {
    private static final long serialVersionUID = 1L;
    public static final int MODUS_ENTWURF = 1;
    public static final int MODUS_AKTION = 2;
    public static final int MODUS_DOKUMENTATION = 3;
    private JBackgroundPanel menupanel;
    private JSlider verzoegerung;
    private FileFilter filiusFileFilter;
    private JLabel geschwindigkeit;
    private int aktuellerModus = 1;
    private JButton btAktionsmodus;
    private JButton btEntwurfsmodus;
    private JButton btDokumodus;
    private JButton btOeffnen;
    private JButton btSpeichern;
    private JButton btNeu;
    private JButton btWizard;
    private JButton btHilfe;
    private JButton btInfo;

    public GUIMainMenu() {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (GUIMainMenu), constr: GUIMainMenu()");
        Container c = JMainFrame.getJMainFrame().getContentPane();
        this.menupanel = new JBackgroundPanel();
        this.menupanel.setPreferredSize(new Dimension(100, 63));
        this.menupanel.setBounds(0, 0, c.getWidth(), 65);
        this.menupanel.setEnabled(false);
        this.menupanel.setBackgroundImage("gfx/allgemein/menue_hg.png");
        this.btOeffnen = new JButton();
        this.btOeffnen.setIcon(new ImageIcon(this.getClass().getResource("/gfx/allgemein/oeffnen.png")));
        this.btOeffnen.setBounds(80, 5, this.btOeffnen.getIcon().getIconWidth(), this.btOeffnen.getIcon().getIconHeight());
        this.btOeffnen.setActionCommand("oeffnen");
        this.btOeffnen.setToolTipText(messages.getString("guimainmemu_msg1"));
        this.btSpeichern = new JButton();
        this.btSpeichern.setIcon(new ImageIcon(this.getClass().getResource("/gfx/allgemein/speichern.png")));
        this.btSpeichern.setBounds(150, 5, this.btSpeichern.getIcon().getIconWidth(), this.btSpeichern.getIcon().getIconHeight());
        this.btSpeichern.setActionCommand("speichern");
        this.btSpeichern.setToolTipText(messages.getString("guimainmemu_msg2"));
        this.btEntwurfsmodus = new JButton();
        this.btEntwurfsmodus.setIcon(new ImageIcon(this.getClass().getResource("/gfx/allgemein/entwurfsmodus_aktiv.png")));
        this.btEntwurfsmodus.setBounds(290, 5, this.btEntwurfsmodus.getIcon().getIconWidth(), this.btEntwurfsmodus.getIcon().getIconHeight());
        this.btEntwurfsmodus.setActionCommand("entwurfsmodus");
        this.btEntwurfsmodus.setToolTipText(messages.getString("guimainmemu_msg3"));
        this.btAktionsmodus = new JButton();
        this.btAktionsmodus.setIcon(new ImageIcon(this.getClass().getResource("/gfx/allgemein/aktionsmodus.png")));
        this.btAktionsmodus.setBounds(360, 5, this.btAktionsmodus.getIcon().getIconWidth(), this.btAktionsmodus.getIcon().getIconHeight());
        this.btAktionsmodus.setActionCommand("aktionsmodus");
        this.btAktionsmodus.setToolTipText(messages.getString("guimainmemu_msg4"));
        this.btNeu = new JButton();
        this.btNeu.setIcon(new ImageIcon(this.getClass().getResource("/gfx/allgemein/neu.png")));
        this.btNeu.setBounds(10, 5, this.btNeu.getIcon().getIconWidth(), this.btNeu.getIcon().getIconHeight());
        this.btNeu.setActionCommand("neu");
        this.btNeu.setToolTipText(messages.getString("guimainmemu_msg5"));
        this.btDokumodus = new JButton();
        this.btDokumodus.setIcon(new ImageIcon(this.getClass().getResource("/gfx/allgemein/dokumodus.png")));
        this.btDokumodus.setBounds(770, 5, this.btDokumodus.getIcon().getIconWidth(), this.btDokumodus.getIcon().getIconHeight());
        this.btDokumodus.setActionCommand("dokumodus");
        this.btDokumodus.setToolTipText(messages.getString("guimainmemu_msg14"));
        if (this.isSoftwareWizardEnabled()) {
            this.btWizard = new JButton();
            this.btWizard.setIcon(new ImageIcon(this.getClass().getResource("/gfx/allgemein/button_wizard.png")));
            this.btWizard.setBounds(660, 5, this.btWizard.getIcon().getIconWidth(), this.btWizard.getIcon().getIconHeight());
            this.btWizard.setActionCommand("wizard");
            this.btWizard.setToolTipText(messages.getString("guimainmemu_msg6"));
        }
        this.btHilfe = new JButton();
        this.btHilfe.setIcon(new ImageIcon(this.getClass().getResource("/gfx/allgemein/hilfe.png")));
        this.btHilfe.setBounds(840, 5, this.btHilfe.getIcon().getIconWidth(), this.btHilfe.getIcon().getIconHeight());
        this.btHilfe.setActionCommand("hilfe");
        this.btHilfe.setToolTipText(messages.getString("guimainmemu_msg7"));
        this.btInfo = new JButton();
        this.btInfo.setIcon(new ImageIcon(this.getClass().getResource("/gfx/allgemein/info.png")));
        this.btInfo.setBounds(910, 5, this.btInfo.getIcon().getIconWidth(), this.btInfo.getIcon().getIconHeight());
        this.btInfo.setActionCommand("info");
        this.btInfo.setToolTipText(messages.getString("guimainmemu_msg8"));
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int entscheidung = 0;
                if (GUIMainMenu.this.isSoftwareWizardEnabled() && e.getActionCommand().equals(GUIMainMenu.this.btWizard.getActionCommand())) {
                    FrameSoftwareWizard gsw = new FrameSoftwareWizard();
                    gsw.setVisible(true);
                }
                if (e.getActionCommand().equals(GUIMainMenu.this.btHilfe.getActionCommand())) {
                    GUIHilfe.getGUIHilfe().anzeigen();
                }
                if (e.getActionCommand().equals(GUIMainMenu.this.btNeu.getActionCommand())) {
                    try {
                        entscheidung = SzenarioVerwaltung.getInstance().istGeaendert() ? JOptionPane.showConfirmDialog(JMainFrame.getJMainFrame(), I18n.messages.getString("guimainmemu_msg9"), I18n.messages.getString("guimainmemu_msg10"), 0) : 0;
                    }
                    catch (Exception exc) {
                        exc.printStackTrace(Main.debug);
                    }
                    if (entscheidung == 0) {
                        GUIContainer.getGUIContainer().clearAllItems();
                        GUIContainer.getGUIContainer().setProperty(null);
                        Information.getInformation().reset();
                        SzenarioVerwaltung.getInstance().reset();
                    }
                }
                if (e.getActionCommand().equals(GUIMainMenu.this.btSpeichern.getActionCommand()) && GUIContainer.getGUIContainer().getActiveSite() != 2) {
                    JFileChooser fcSpeichern = new JFileChooser();
                    fcSpeichern.setFileFilter(GUIMainMenu.this.filiusFileFilter);
                    GUIMainMenu.this.initCurrentFileOrDirSelection(fcSpeichern);
                    if (fcSpeichern.showSaveDialog(JMainFrame.getJMainFrame()) == 0 && fcSpeichern.getSelectedFile() != null) {
                        Information.getInformation().setLastOpenedDirectory(fcSpeichern.getSelectedFile().getParent());
                        String targetFilePath = fcSpeichern.getSelectedFile().getName().endsWith(".fls") ? fcSpeichern.getSelectedFile().getPath() : fcSpeichern.getSelectedFile().getPath() + ".fls";
                        boolean erfolg = SzenarioVerwaltung.getInstance().speichern(targetFilePath, GUIContainer.getGUIContainer().getKnotenItems(), GUIContainer.getGUIContainer().getCableItems(), GUIContainer.getGUIContainer().getDocuItems());
                        if (!erfolg) {
                            JOptionPane.showMessageDialog(JMainFrame.getJMainFrame(), I18n.messages.getString("guimainmemu_msg11"));
                        }
                    }
                }
                if (e.getActionCommand().equals(GUIMainMenu.this.btOeffnen.getActionCommand())) {
                    try {
                        entscheidung = SzenarioVerwaltung.getInstance().istGeaendert() ? JOptionPane.showConfirmDialog(JMainFrame.getJMainFrame(), I18n.messages.getString("guimainmemu_msg9"), I18n.messages.getString("guimainmemu_msg10"), 0) : 0;
                    }
                    catch (Exception exc) {
                        exc.printStackTrace(Main.debug);
                    }
                    if (entscheidung == 0 && GUIContainer.getGUIContainer().getActiveSite() == 1) {
                        JFileChooser fcLaden = new JFileChooser();
                        fcLaden.setFileFilter(GUIMainMenu.this.filiusFileFilter);
                        GUIMainMenu.this.initCurrentFileOrDirSelection(fcLaden);
                        if (fcLaden.showOpenDialog(JMainFrame.getJMainFrame()) == 0 && fcLaden.getSelectedFile() != null) {
                            Information.getInformation().setLastOpenedDirectory(fcLaden.getSelectedFile().getParent());
                            try {
                                Information.getInformation().reset();
                                SzenarioVerwaltung.getInstance().laden(fcLaden.getSelectedFile().getPath(), GUIContainer.getGUIContainer().getKnotenItems(), GUIContainer.getGUIContainer().getCableItems(), GUIContainer.getGUIContainer().getDocuItems());
                                GUIContainer.getGUIContainer().setProperty(null);
                                GUIContainer.getGUIContainer().updateViewport();
                                Thread.sleep(10L);
                                GUIContainer.getGUIContainer().updateCables();
                            }
                            catch (FileNotFoundException e1) {
                                e1.printStackTrace(Main.debug);
                            }
                            catch (Exception e2) {
                                e2.printStackTrace(Main.debug);
                            }
                        }
                    }
                }
                if (e.getActionCommand().equals(GUIMainMenu.this.btEntwurfsmodus.getActionCommand())) {
                    GUIMainMenu.this.selectMode(1);
                } else if (e.getActionCommand().equals(GUIMainMenu.this.btAktionsmodus.getActionCommand())) {
                    GUIMainMenu.this.selectMode(2);
                } else if (e.getActionCommand().equals(GUIMainMenu.this.btDokumodus.getActionCommand())) {
                    GUIMainMenu.this.selectMode(3);
                } else if (e.getActionCommand().equals(GUIMainMenu.this.btInfo.getActionCommand())) {
                    new InfoDialog(JMainFrame.getJMainFrame()).setVisible(true);
                }
            }
        };
        this.btNeu.addActionListener(al);
        this.btOeffnen.addActionListener(al);
        this.btSpeichern.addActionListener(al);
        this.btEntwurfsmodus.addActionListener(al);
        this.btAktionsmodus.addActionListener(al);
        this.btDokumodus.addActionListener(al);
        if (this.isSoftwareWizardEnabled()) {
            this.btWizard.addActionListener(al);
        }
        this.btInfo.addActionListener(al);
        this.btHilfe.addActionListener(al);
        this.geschwindigkeit = new JLabel("100%");
        this.geschwindigkeit.setVisible(true);
        this.geschwindigkeit.setAlignmentX(1.0f);
        this.geschwindigkeit.setBounds(552, 10, 120, 44);
        this.verzoegerung = new JSlider(0, 100);
        this.verzoegerung.setMaximum(10);
        this.verzoegerung.setMinimum(1);
        this.verzoegerung.setValue(this.verzoegerung.getMaximum());
        Verbindung.setzeVerzoegerungsFaktor(this.verzoegerung.getMaximum() - this.verzoegerung.getValue() + 1);
        this.verzoegerung.setBounds(450, 10, 100, 44);
        this.verzoegerung.setOpaque(false);
        this.verzoegerung.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                Verbindung.setzeVerzoegerungsFaktor(GUIMainMenu.this.verzoegerung.getMaximum() - GUIMainMenu.this.verzoegerung.getValue() + 1);
                GUIMainMenu.this.geschwindigkeit.setText("" + GUIMainMenu.this.verzoegerung.getValue() * 10 + "%");
            }
        });
        this.menupanel.setLayout(null);
        this.menupanel.add(this.btEntwurfsmodus);
        this.menupanel.add(this.btAktionsmodus);
        this.menupanel.add(this.btDokumodus);
        this.menupanel.add(this.btNeu);
        this.menupanel.add(this.btOeffnen);
        this.menupanel.add(this.btSpeichern);
        this.menupanel.add(this.verzoegerung);
        this.menupanel.add(this.geschwindigkeit);
        if (this.isSoftwareWizardEnabled()) {
            this.menupanel.add(this.btWizard);
        }
        this.menupanel.add(this.btHilfe);
        this.menupanel.add(this.btInfo);
        this.filiusFileFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.isDirectory()) {
                    return true;
                }
                return pathname.getName().toLowerCase().endsWith(".fls");
            }

            @Override
            public String getDescription() {
                return I18n.messages.getString("guimainmemu_msg13");
            }
        };
    }

    private void initCurrentFileOrDirSelection(JFileChooser fcLaden) {
        String scenarioPath = SzenarioVerwaltung.getInstance().holePfad();
        String lastOpenedDir = Information.getInformation().getLastOpenedDirectory();
        File file = null;
        if (scenarioPath != null) {
            file = new File(scenarioPath);
        }
        if (null != file && file.exists()) {
            fcLaden.setSelectedFile(file);
        } else if (null != lastOpenedDir && (file = new File(lastOpenedDir)).exists()) {
            fcLaden.setCurrentDirectory(file);
        }
    }

    private boolean isSoftwareWizardEnabled() {
        return null != ToolProvider.getSystemJavaCompiler() && Information.getInformation().getSoftwareWizardMode() != Information.FeatureMode.FORCE_DISABLE || Information.getInformation().getSoftwareWizardMode() == Information.FeatureMode.FORCE_ENABLE;
    }

    public void changeSlider(int diff) {
        if (diff < 0 && this.verzoegerung.getValue() + diff < 1) {
            this.verzoegerung.setValue(1);
        } else if (diff > 0 && this.verzoegerung.getValue() + diff > 10) {
            this.verzoegerung.setValue(10);
        } else {
            this.verzoegerung.setValue(this.verzoegerung.getValue() + diff);
        }
    }

    public boolean doClick(String button) {
        if (button.equals("btAktionsmodus")) {
            this.btAktionsmodus.doClick();
        } else if (button.equals("btEntwurfsmodus")) {
            this.btEntwurfsmodus.doClick();
        } else if (button.equals("btDokumodus")) {
            this.btDokumodus.doClick();
        } else if (button.equals("btOeffnen")) {
            this.btOeffnen.doClick();
        } else if (button.equals("btSpeichern")) {
            this.btSpeichern.doClick();
        } else if (button.equals("btNeu")) {
            this.btNeu.doClick();
        } else if (button.equals("btWizard")) {
            this.btWizard.doClick();
        } else if (button.equals("btHilfe")) {
            this.btHilfe.doClick();
        } else if (button.equals("btInfo")) {
            this.btInfo.doClick();
        } else {
            return false;
        }
        return true;
    }

    private void resetCableHighlighting(int mode) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (GUIMainMenu), resetCableHL(" + mode + ")");
        if (mode == 2) {
            for (GUIKabelItem cableItem : GUIContainer.getGUIContainer().getCableItems()) {
                cableItem.getDasKabel().setAktiv(false);
            }
        } else if (GUIContainer.getGUIContainer().getProperty() instanceof JVermittlungsrechnerKonfiguration) {
            ((JVermittlungsrechnerKonfiguration)GUIContainer.getGUIContainer().getProperty()).highlightConnCable();
        }
    }

    public synchronized void selectMode(int mode) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (GUIMainMenu), selectMode(" + mode + ")");
        if (mode == 1) {
            this.resetCableHighlighting(mode);
            this.btEntwurfsmodus.setIcon(new ImageIcon(this.getClass().getResource("/gfx/allgemein/entwurfsmodus_aktiv.png")));
            this.btAktionsmodus.setIcon(new ImageIcon(this.getClass().getResource("/gfx/allgemein/aktionsmodus.png")));
            this.btDokumodus.setIcon(new ImageIcon(this.getClass().getResource("/gfx/allgemein/dokumodus.png")));
            GUIContainer.getGUIContainer().setActiveSite(1);
            GUIHilfe.getGUIHilfe().laden("entwurfsmodus");
            this.stopSimulation();
            this.btOeffnen.setEnabled(true);
            this.btNeu.setEnabled(true);
            this.btSpeichern.setEnabled(true);
            if (this.isSoftwareWizardEnabled()) {
                this.btWizard.setEnabled(true);
            }
        } else if (mode == 3) {
            this.resetCableHighlighting(mode);
            this.btEntwurfsmodus.setIcon(new ImageIcon(this.getClass().getResource("/gfx/allgemein/entwurfsmodus.png")));
            this.btAktionsmodus.setIcon(new ImageIcon(this.getClass().getResource("/gfx/allgemein/aktionsmodus.png")));
            this.btDokumodus.setIcon(new ImageIcon(this.getClass().getResource("/gfx/allgemein/dokumodus_aktiv.png")));
            GUIContainer.getGUIContainer().setActiveSite(3);
            GUIHilfe.getGUIHilfe().laden("entwurfsmodus");
            this.stopSimulation();
            this.btOeffnen.setEnabled(true);
            this.btNeu.setEnabled(true);
            this.btSpeichern.setEnabled(true);
            if (this.isSoftwareWizardEnabled()) {
                this.btWizard.setEnabled(false);
            }
        } else if (mode == 2 && this.aktuellerModus != 2) {
            this.resetCableHighlighting(mode);
            this.btEntwurfsmodus.setIcon(new ImageIcon(this.getClass().getResource("/gfx/allgemein/entwurfsmodus.png")));
            this.btAktionsmodus.setIcon(new ImageIcon(this.getClass().getResource("/gfx/allgemein/aktionsmodus_aktiv.png")));
            this.btDokumodus.setIcon(new ImageIcon(this.getClass().getResource("/gfx/allgemein/dokumodus.png")));
            GUIContainer.getGUIContainer().setActiveSite(2);
            GUIHilfe.getGUIHilfe().laden("simulationsmodus");
            for (GUIKnotenItem knotenItem : GUIContainer.getGUIContainer().getKnotenItems()) {
                SystemSoftware system = knotenItem.getKnoten().getSystemSoftware();
                system.starten();
            }
            this.btOeffnen.setEnabled(false);
            this.btNeu.setEnabled(false);
            this.btSpeichern.setEnabled(false);
            if (this.isSoftwareWizardEnabled()) {
                this.btWizard.setEnabled(false);
            }
            this.geschwindigkeit.setEnabled(true);
            this.verzoegerung.setEnabled(true);
        }
        this.aktuellerModus = mode;
    }

    private void stopSimulation() {
        for (GUIKnotenItem knotenItem : GUIContainer.getGUIContainer().getKnotenItems()) {
            SystemSoftware system = knotenItem.getKnoten().getSystemSoftware();
            try {
                system.beenden();
            }
            catch (Exception exception) {}
        }
        ((JDialog)((Object)GUIContainer.getGUIContainer().getExchangeDialog())).setVisible(false);
    }

    public JBackgroundPanel getMenupanel() {
        return this.menupanel;
    }

    public void setMenupanel(JBackgroundPanel menupanel) {
        this.menupanel = menupanel;
    }
}

