/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.anwendungssicht;

import filius.Main;
import filius.gui.anwendungssicht.GUIApplicationWindow;
import filius.gui.anwendungssicht.GUIDesktopPanel;
import filius.rahmenprogramm.I18n;
import filius.software.lokal.Terminal;
import filius.software.system.Dateisystem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Observable;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.InternalFrameEvent;

public class GUIApplicationTerminalWindow
extends GUIApplicationWindow {
    private static final String MENU_LINE = "==========================================================================\n";
    private JTextArea terminalField;
    private JPanel backPanel;
    private JTextField inputField;
    private JLabel inputLabel;
    private JScrollPane tpPane;
    private boolean jobRunning;
    private String enteredCommand;
    private String[] enteredParameters;
    private boolean multipleObserverEvents;
    private ArrayList<String> commandHistory = new ArrayList();
    private int commandHistoryPointer = -1;

    public GUIApplicationTerminalWindow(GUIDesktopPanel desktop, String appName) {
        super(desktop, appName);
        this.setMaximizable(false);
        this.setResizable(false);
        this.jobRunning = false;
        this.multipleObserverEvents = false;
        this.terminalField = new JTextArea("");
        this.terminalField.setEditable(false);
        this.terminalField.setCaretColor(new Color(222, 222, 222));
        this.terminalField.setForeground(new Color(222, 222, 222));
        this.terminalField.setBackground(new Color(0, 0, 0));
        this.terminalField.setFont(new Font("Monospaced", 0, 11));
        this.terminalField.setFocusable(false);
        this.terminalField.setBorder(null);
        this.tpPane = new JScrollPane(this.terminalField);
        this.tpPane.setBorder(null);
        this.tpPane.setBackground(new Color(0, 0, 0));
        this.tpPane.setVerticalScrollBarPolicy(21);
        this.tpPane.setHorizontalScrollBarPolicy(31);
        this.inputField = new JTextField("");
        this.inputField.setEditable(true);
        this.inputField.setBackground(new Color(0, 0, 0));
        this.inputField.setForeground(new Color(222, 222, 222));
        this.inputField.setCaretColor(new Color(222, 222, 222));
        this.inputField.setBorder(null);
        this.inputField.setFont(new Font("Courier New", 0, 11));
        this.inputField.setOpaque(false);
        this.inputField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    GUIApplicationTerminalWindow.this.commandHistoryPointer = -1;
                    if (!GUIApplicationTerminalWindow.this.inputField.getText().isEmpty() && !GUIApplicationTerminalWindow.this.inputField.getText().replaceAll(" ", "").isEmpty()) {
                        GUIApplicationTerminalWindow.this.terminalField.append("\n" + GUIApplicationTerminalWindow.this.inputLabel.getText() + GUIApplicationTerminalWindow.this.inputField.getText() + "\n");
                        StringTokenizer tk = new StringTokenizer(GUIApplicationTerminalWindow.this.inputField.getText(), " ");
                        GUIApplicationTerminalWindow.this.enteredCommand = tk.nextToken();
                        GUIApplicationTerminalWindow.access$502(GUIApplicationTerminalWindow.this, new String[3 + tk.countTokens()]);
                        for (int i = 0; i < 3 + tk.countTokens(); ++i) {
                            ((GUIApplicationTerminalWindow)GUIApplicationTerminalWindow.this).enteredParameters[i] = new String();
                        }
                        int iti = 0;
                        while (tk.hasMoreTokens()) {
                            ((GUIApplicationTerminalWindow)GUIApplicationTerminalWindow.this).enteredParameters[iti] = tk.nextToken();
                            ++iti;
                        }
                        if (GUIApplicationTerminalWindow.this.enteredCommand.equals("exit")) {
                            GUIApplicationTerminalWindow.this.doDefaultCloseAction();
                        } else if (GUIApplicationTerminalWindow.this.enteredCommand.equals("reset")) {
                            GUIApplicationTerminalWindow.this.terminalField.setText("");
                            for (int i = 0; i < 15; ++i) {
                                GUIApplicationTerminalWindow.this.terminalField.append(" \n");
                            }
                            GUIApplicationTerminalWindow.this.terminalField.append(GUIApplicationTerminalWindow.MENU_LINE);
                            GUIApplicationTerminalWindow.this.terminalField.append(I18n.messages.getString("sw_terminal_msg25") + GUIApplicationTerminalWindow.MENU_LINE);
                        } else {
                            GUIApplicationTerminalWindow.this.inputLabel.setVisible(false);
                            GUIApplicationTerminalWindow.this.jobRunning = true;
                            GUIApplicationTerminalWindow.this.commandHistory.add(GUIApplicationTerminalWindow.this.inputField.getText());
                            ((Terminal)GUIApplicationTerminalWindow.this.holeAnwendung()).terminalEingabeAuswerten(GUIApplicationTerminalWindow.this.enteredCommand, GUIApplicationTerminalWindow.this.enteredParameters);
                        }
                    } else {
                        GUIApplicationTerminalWindow.this.terminalField.append("\n");
                    }
                    GUIApplicationTerminalWindow.this.inputField.setText("");
                }
                if (e.getKeyCode() == 67 && e.getModifiers() == 2) {
                    ((Terminal)GUIApplicationTerminalWindow.this.holeAnwendung()).setInterrupt(true);
                }
                if (e.getKeyCode() == 38 || e.getKeyCode() == 40) {
                    if (e.getKeyCode() == 38) {
                        GUIApplicationTerminalWindow.this.commandHistoryPointer++;
                    }
                    if (e.getKeyCode() == 40) {
                        GUIApplicationTerminalWindow.this.commandHistoryPointer--;
                    }
                    if (GUIApplicationTerminalWindow.this.commandHistoryPointer < -1) {
                        GUIApplicationTerminalWindow.this.commandHistoryPointer = -1;
                    }
                    if (GUIApplicationTerminalWindow.this.commandHistoryPointer >= GUIApplicationTerminalWindow.this.commandHistory.size()) {
                        GUIApplicationTerminalWindow.this.commandHistoryPointer = GUIApplicationTerminalWindow.this.commandHistory.size() - 1;
                    }
                    try {
                        if (GUIApplicationTerminalWindow.this.commandHistoryPointer != -1) {
                            GUIApplicationTerminalWindow.this.inputField.setText((String)GUIApplicationTerminalWindow.this.commandHistory.get(GUIApplicationTerminalWindow.this.commandHistory.size() - 1 - GUIApplicationTerminalWindow.this.commandHistoryPointer));
                        } else if (GUIApplicationTerminalWindow.this.commandHistoryPointer == -1) {
                            GUIApplicationTerminalWindow.this.inputField.setText("");
                        }
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }

            @Override
            public void keyTyped(KeyEvent arg0) {
            }
        });
        this.inputLabel = new JLabel(">");
        this.inputLabel.setBackground(new Color(0, 0, 0));
        this.inputLabel.setForeground(new Color(222, 222, 222));
        this.inputLabel.setFont(new Font("Courier New", 0, 11));
        Box terminalBox = Box.createHorizontalBox();
        terminalBox.setBackground(new Color(0, 0, 0));
        terminalBox.add(this.tpPane);
        terminalBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 1, 5));
        Box inputBox = Box.createHorizontalBox();
        inputBox.setBackground(new Color(0, 0, 0));
        inputBox.add(this.inputLabel);
        inputBox.add(Box.createHorizontalStrut(1));
        inputBox.add(this.inputField);
        inputBox.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        this.backPanel = new JPanel(new BorderLayout());
        this.backPanel.setBackground(new Color(0, 0, 0));
        this.backPanel.add((Component)terminalBox, "Center");
        this.backPanel.add((Component)inputBox, "South");
        this.getContentPane().add(this.backPanel);
        this.terminalField.setText("");
        for (int i = 0; i < 10; ++i) {
            this.terminalField.append(" \n");
        }
        this.terminalField.append(MENU_LINE);
        this.terminalField.append(messages.getString("sw_terminal_msg25"));
        this.terminalField.append(MENU_LINE);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.tpPane.getVerticalScrollBar().setValue(this.tpPane.getVerticalScrollBar().getMaximum());
        this.pack();
        this.inputField.requestFocus();
        this.inputLabel.setText("root " + Dateisystem.absoluterPfad(((Terminal)this.holeAnwendung()).getAktuellerOrdner()) + "> ");
    }

    public void setMultipleObserverEvents(boolean flag) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void internalFrameActivated(InternalFrameEvent e) {
    }

    public void internalFrameClosed(InternalFrameEvent e) {
    }

    public void internalFrameClosing(InternalFrameEvent e) {
    }

    public void internalFrameDeactivated(InternalFrameEvent e) {
    }

    public void internalFrameDeiconified(InternalFrameEvent e) {
    }

    public void internalFrameIconified(InternalFrameEvent e) {
    }

    public void internalFrameOpened(InternalFrameEvent e) {
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (GUIApplicationTerminalWindow), update(" + arg0 + "," + arg1 + ")");
        if (arg1 == null) {
            return;
        }
        if (this.jobRunning) {
            if (arg1 instanceof Boolean) {
                this.multipleObserverEvents = (Boolean)arg1;
            } else {
                this.terminalField.append(arg1.toString());
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.tpPane.repaint();
                this.tpPane.getVerticalScrollBar().setValue(this.tpPane.getVerticalScrollBar().getMaximum());
                if (!this.multipleObserverEvents) {
                    this.inputLabel.setText("root " + Dateisystem.absoluterPfad(((Terminal)this.holeAnwendung()).getAktuellerOrdner()) + "> ");
                    this.inputLabel.setVisible(true);
                    this.jobRunning = false;
                }
            }
        }
    }

    static /* synthetic */ String[] access$502(GUIApplicationTerminalWindow x0, String[] x1) {
        x0.enteredParameters = x1;
        return x1;
    }
}

