/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.anwendungssicht;

import filius.Main;
import filius.gui.JBackgroundPanel;
import filius.gui.anwendungssicht.GUIApplicationWindow;
import filius.gui.anwendungssicht.GUIDesktopIcon;
import filius.gui.anwendungssicht.GUIInstallationsDialog;
import filius.gui.anwendungssicht.GUINetworkWindow;
import filius.gui.anwendungssicht.JBackgroundDesktopPane;
import filius.hardware.NetzwerkInterface;
import filius.hardware.knoten.InternetKnoten;
import filius.rahmenprogramm.FiliusClassLoader;
import filius.rahmenprogramm.I18n;
import filius.rahmenprogramm.Information;
import filius.software.system.Betriebssystem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;

public class GUIDesktopPanel
extends JBackgroundPanel
implements I18n,
Observer {
    private static final long serialVersionUID = 1L;
    private Betriebssystem betriebssystem;
    private HashMap<String, GUIApplicationWindow> laufendeAnwendung = new HashMap();
    private JBackgroundDesktopPane desktopPane = null;
    private JPanel iconPanel = null;
    private JPanel taskLeiste;
    private JLabel lbNetzwerk;
    private GUIInstallationsDialog installationsDialog = null;
    private GUINetworkWindow gnw;
    private String[] parameter = new String[]{"", "", ""};

    public GUIDesktopPanel(Betriebssystem betriebssystem) {
        this.setLayout(null);
        this.setPreferredSize(new Dimension(640, 480));
        this.setBounds(0, 0, 640, 480);
        this.setBackgroundImage("gfx/desktop/hintergrundbild.png");
        this.setVisible(true);
        this.setLayout(new BorderLayout());
        this.betriebssystem = betriebssystem;
        betriebssystem.addObserver(this);
        this.desktopPane = new JBackgroundDesktopPane();
        this.desktopPane.setBackgroundImage("gfx/desktop/hintergrundbild.png");
        this.add((Component)this.desktopPane, "Center");
        this.iconPanel = new JPanel(new FlowLayout(0, 5, 10));
        this.iconPanel.setBounds(0, 0, 640, 432);
        this.iconPanel.setOpaque(false);
        this.taskLeiste = new JPanel();
        this.taskLeiste.setBorder(BorderFactory.createEmptyBorder());
        Box boxTaskLeiste = Box.createHorizontalBox();
        boxTaskLeiste.setBorder(BorderFactory.createEmptyBorder());
        boxTaskLeiste.add(Box.createHorizontalStrut(600));
        this.gnw = new GUINetworkWindow(this);
        this.lbNetzwerk = new JLabel(new ImageIcon(this.getClass().getResource("/gfx/desktop/netzwek_aus.png")));
        this.lbNetzwerk.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                GUIDesktopPanel.this.gnw.setVisible(true);
                try {
                    GUIDesktopPanel.this.gnw.setSelected(true);
                    GUIDesktopPanel.this.gnw.toFront();
                }
                catch (PropertyVetoException e1) {
                    e1.printStackTrace(Main.debug);
                }
            }
        });
        boxTaskLeiste.add(this.lbNetzwerk);
        this.taskLeiste.add(boxTaskLeiste);
        this.add((Component)this.taskLeiste, "South");
        this.desktopPane.add(this.iconPanel);
        this.desktopPane.validate();
        this.updateAnwendungen();
    }

    public void updateAnwendungen() {
        ListIterator<Map<String, String>> it;
        List<Map<String, String>> softwareList = null;
        Class<?> cl = null;
        try {
            softwareList = Information.getInformation().ladeProgrammListe();
        }
        catch (IOException e) {
            e.printStackTrace(Main.debug);
        }
        this.iconPanel.removeAll();
        GUIDesktopIcon tmpLabel = new GUIDesktopIcon(new ImageIcon(this.getClass().getResource("/gfx/desktop/icon_softwareinstallation.png")));
        tmpLabel.setAnwendungsName(messages.getString("desktoppanel_msg1"));
        tmpLabel.setInvokeName("Software-Installation");
        tmpLabel.setToolTipText(tmpLabel.getAnwendungsName());
        tmpLabel.setText(tmpLabel.getAnwendungsName());
        tmpLabel.setVerticalTextPosition(3);
        tmpLabel.setHorizontalTextPosition(0);
        tmpLabel.setForeground(new Color(255, 255, 255));
        tmpLabel.setPreferredSize(new Dimension(120, 96));
        this.iconPanel.add(tmpLabel);
        ListIterator<Map<String, String>> listIterator = it = softwareList != null ? softwareList.listIterator() : null;
        while (it != null && it.hasNext()) {
            HashMap tmpMap = (HashMap)it.next();
            String softwareKlasse = (String)tmpMap.get("Klasse");
            if (this.betriebssystem.holeSoftware(softwareKlasse) == null || !softwareKlasse.equals((String)tmpMap.get("Klasse"))) continue;
            String guiKlassenName = (String)tmpMap.get("GUI-Klasse");
            try {
                cl = Class.forName(guiKlassenName, true, FiliusClassLoader.getInstance(Thread.currentThread().getContextClassLoader()));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace(Main.debug);
            }
            try {
                if (cl == null) continue;
                GUIApplicationWindow tempWindow = (GUIApplicationWindow)cl.getConstructor(GUIDesktopPanel.class, String.class).newInstance(this, softwareKlasse);
                tempWindow.setVisible(false);
                this.addLaufendeAnwendung(softwareKlasse, tempWindow);
                tmpLabel = new GUIDesktopIcon(new ImageIcon(this.getClass().getResource("/" + (String)tmpMap.get("gfxFile"))));
                tmpLabel.setAnwendungsName((String)tmpMap.get("Anwendung"));
                tmpLabel.setInvokeName((String)tmpMap.get("Klasse"));
                tmpLabel.setToolTipText(tmpLabel.getAnwendungsName());
                tmpLabel.setText(tmpLabel.getAnwendungsName());
                tmpLabel.setVerticalTextPosition(3);
                tmpLabel.setHorizontalTextPosition(0);
                tmpLabel.setForeground(new Color(255, 255, 255));
                tmpLabel.setPreferredSize(new Dimension(120, 96));
                this.iconPanel.add(tmpLabel);
            }
            catch (Exception e) {
                e.printStackTrace(Main.debug);
            }
        }
        this.iconPanel.updateUI();
        NetzwerkInterface nic = ((InternetKnoten)this.betriebssystem.getKnoten()).getNetzwerkInterfaces().get(0);
        if (nic != null && nic.getPort() != null && nic.getPort().getVerbindung() != null) {
            nic.getPort().getVerbindung().addObserver(this);
            this.lbNetzwerk.setToolTipText("" + nic.getIp());
        }
        if (this.getParent() != null) {
            this.taskLeiste.setBounds(0, 424, 640, 32 + this.getParent().getInsets().top);
        }
    }

    public GUIApplicationWindow starteAnwendung(String softwareKlasse, String[] param) {
        this.setParameter(param);
        return this.starteAnwendung(softwareKlasse);
    }

    public GUIApplicationWindow starteAnwendung(String softwareKlasse) {
        GUIApplicationWindow tempWindow = null;
        if (softwareKlasse.equals("Software-Installation")) {
            this.installationsDialog = new GUIInstallationsDialog(this);
            this.getDesktopPane().add((Component)this.installationsDialog, 3);
            try {
                this.installationsDialog.setSelected(true);
            }
            catch (PropertyVetoException e) {
                e.printStackTrace(Main.debug);
            }
        } else if (this.getLaufendeAnwendungByName(softwareKlasse) != null) {
            tempWindow = this.getLaufendeAnwendungByName(softwareKlasse);
            tempWindow.updateUI();
            tempWindow.starten(this.parameter);
            tempWindow.show();
        }
        return tempWindow;
    }

    private void addLaufendeAnwendung(String anwendungsName, GUIApplicationWindow fenster) {
        this.laufendeAnwendung.put(anwendungsName, fenster);
    }

    private GUIApplicationWindow getLaufendeAnwendungByName(String anwendungsName) {
        GUIApplicationWindow tmpFenster = null;
        tmpFenster = this.laufendeAnwendung.get(anwendungsName);
        return tmpFenster;
    }

    public Betriebssystem getBetriebssystem() {
        return this.betriebssystem;
    }

    public JDesktopPane getDesktopPane() {
        return this.desktopPane;
    }

    public String[] getParameter() {
        return this.parameter;
    }

    public void setParameter(String[] parameter) {
        this.parameter = parameter;
    }

    @Override
    public void update(Observable o, Object arg) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (GUIDesktopPanel), update(" + o + "," + arg + ")");
        if (arg == null) {
            this.updateAnwendungen();
        } else if (arg.equals(Boolean.TRUE)) {
            this.lbNetzwerk.setIcon(new ImageIcon(this.getClass().getResource("/gfx/desktop/netzwek_c.png")));
        } else {
            this.lbNetzwerk.setIcon(new ImageIcon(this.getClass().getResource("/gfx/desktop/netzwek_aus.png")));
        }
    }
}

