/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.netzwerksicht;

import filius.Main;
import filius.gui.JBackgroundPanel;
import filius.gui.JMainFrame;
import filius.gui.netzwerksicht.JHostKonfiguration;
import filius.gui.netzwerksicht.JModemKonfiguration;
import filius.gui.netzwerksicht.JSwitchKonfiguration;
import filius.gui.netzwerksicht.JVermittlungsrechnerKonfiguration;
import filius.hardware.Hardware;
import filius.hardware.knoten.Host;
import filius.hardware.knoten.Modem;
import filius.hardware.knoten.Switch;
import filius.hardware.knoten.Vermittlungsrechner;
import filius.rahmenprogramm.EingabenUeberpruefung;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.MouseInputAdapter;

public class JKonfiguration
extends JBackgroundPanel
implements Observer {
    private static final long serialVersionUID = 1L;
    private JBackgroundPanel attributPanel;
    private JLabel minimierenButton;
    private Hardware hardware;
    protected static HashMap<Hardware, JKonfiguration> instances = new HashMap();
    private static final int HOEHE = 250;

    protected JKonfiguration(Hardware hardware) {
        this.hardware = hardware;
        this.initKonfigPanel();
        if (hardware != null) {
            hardware.addObserver(this);
            this.initAttributPanel();
            this.updateAttribute();
        }
        this.minimieren();
    }

    public static JKonfiguration getInstance(Hardware hardware) {
        if (hardware == null) {
            return new JKonfiguration(null);
        }
        if (!instances.containsKey(hardware)) {
            JKonfiguration newInstance = hardware instanceof Host ? new JHostKonfiguration(hardware) : (hardware instanceof Modem ? new JModemKonfiguration(hardware) : (hardware instanceof Switch ? new JSwitchKonfiguration(hardware) : (hardware instanceof Vermittlungsrechner ? new JVermittlungsrechnerKonfiguration(hardware) : new JKonfiguration(null))));
            instances.put(hardware, newInstance);
        }
        return instances.get(hardware);
    }

    public Hardware holeHardware() {
        return this.hardware;
    }

    private void initKonfigPanel() {
        Container c = JMainFrame.getJMainFrame().getContentPane();
        final JKonfiguration konfigPanel = this;
        this.setLayout(null);
        this.setBounds(0, 0, c.getWidth(), 100);
        this.setEnabled(false);
        this.setBackgroundImage("gfx/allgemein/konfigPanel_hg.png");
        this.setPreferredSize(new Dimension(100, 250));
        this.setLayout(new BorderLayout());
        this.attributPanel = new JBackgroundPanel();
        this.attributPanel.setBackgroundImage("gfx/allgemein/konfigPanel_hg.png");
        this.attributPanel.setOpaque(false);
        this.attributPanel.setVisible(true);
        this.attributPanel.setBounds(0, 0, c.getWidth(), 300);
        this.add((Component)new JScrollPane(this.attributPanel), "Center");
        this.minimierenButton = new JLabel(new ImageIcon(this.getClass().getResource("/gfx/allgemein/minimieren.png")));
        this.minimierenButton.setBounds(0, 0, this.minimierenButton.getIcon().getIconWidth(), this.minimierenButton.getIcon().getIconHeight());
        this.minimierenButton.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (konfigPanel.getHeight() > 20) {
                    konfigPanel.minimieren();
                } else {
                    konfigPanel.maximieren();
                }
            }
        });
        this.add((Component)this.minimierenButton, "North");
    }

    private void initAttributPanel() {
        this.attributPanel.removeAll();
        this.attributPanel.updateUI();
        this.attributPanel.setLayout(new BorderLayout());
        Box hauptBox = Box.createVerticalBox();
        hauptBox.add(Box.createHorizontalGlue());
        hauptBox.setOpaque(false);
        hauptBox.setAlignmentX(0.0f);
        hauptBox.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        Box auxBox = Box.createVerticalBox();
        auxBox.add(Box.createHorizontalGlue());
        auxBox.setOpaque(false);
        auxBox.setAlignmentX(0.0f);
        auxBox.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.initAttributEingabeBox(hauptBox, auxBox);
        this.attributPanel.add((Component)hauptBox, "Center");
        this.attributPanel.add((Component)auxBox, "After");
        this.attributPanel.updateUI();
        this.attributPanel.invalidate();
        this.attributPanel.validate();
    }

    public void reInit() {
        this.initAttributPanel();
    }

    public void minimieren() {
        this.setPreferredSize(new Dimension(this.getWidth(), 20));
        this.minimierenButton.setIcon(new ImageIcon(this.getClass().getResource("/gfx/allgemein/maximieren.png")));
        this.attributPanel.setVisible(false);
        this.updateUI();
    }

    public void updateSettings() {
    }

    public void doUnselectAction() {
    }

    public void maximieren() {
        this.setPreferredSize(new Dimension(this.getWidth(), 250));
        this.minimierenButton.setIcon(new ImageIcon(this.getClass().getResource("/gfx/allgemein/minimieren.png")));
        this.updateSettings();
        this.attributPanel.setVisible(true);
        this.updateUI();
    }

    public boolean isMaximiert() {
        return this.attributPanel.isVisible();
    }

    public void aenderungenAnnehmen() {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (JKonfiguration), aenderungenAnnehmen()");
    }

    protected void initAttributEingabeBox(Box box, Box rightBox) {
    }

    public void updateAttribute() {
    }

    public boolean ueberpruefen(Pattern pruefRegel, JTextField feld) {
        if (EingabenUeberpruefung.isGueltig(feld.getText(), pruefRegel)) {
            feld.setForeground(EingabenUeberpruefung.farbeRichtig);
            return true;
        }
        feld.setForeground(EingabenUeberpruefung.farbeFalsch);
        return false;
    }

    @Override
    public void update(Observable o, Object arg) {
        this.updateAttribute();
    }
}

