/*
 * Decompiled with CFR 0.152.
 */
package filius.software.dns;

import filius.Main;
import filius.software.clientserver.ServerMitarbeiter;
import filius.software.dns.DNSNachricht;
import filius.software.dns.DNSServer;
import filius.software.dns.Query;
import filius.software.dns.Resolver;
import filius.software.dns.ResourceRecord;
import filius.software.transportschicht.Socket;
import filius.software.transportschicht.UDPSocket;
import java.util.concurrent.TimeoutException;

public class DNSServerMitarbeiter
extends ServerMitarbeiter {
    public DNSServerMitarbeiter(DNSServer server, Socket socket) {
        super(server, socket);
    }

    @Override
    protected void verarbeiteNachricht(String dateneinheit) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (DNSServerMitarbeiter), verarbeiteNachricht(" + dateneinheit + ")");
        DNSNachricht nachricht = new DNSNachricht(dateneinheit);
        DNSNachricht antwort = new DNSNachricht(1);
        antwort.setId(nachricht.getId());
        for (Query query : nachricht.holeQueries()) {
            this.server.benachrichtigeBeobachter(messages.getString("sw_dnsservermitarbeiter_msg1") + query);
            ResourceRecord record = ((DNSServer)this.server).holeRecord(query.holeDomainname(), query.holeTyp());
            if (record == null) {
                record = ((DNSServer)this.server).holeNSRecord(query.holeDomainname());
            }
            if (record == null) continue;
            if (record.getType().equals("A")) {
                antwort.hinzuAntwortResourceRecord(record.toString());
                continue;
            }
            if (record.getType().equals("NS")) {
                if (((DNSServer)this.server).isRecursiveResolutionEnabled()) {
                    Resolver resolver = this.server.getSystemSoftware().holeDNSClient();
                    if ((record = ((DNSServer)this.server).holeRecord(record.getRdata(), "A")) == null) continue;
                    try {
                        String ipAdresse = resolver.holeIPAdresse(query.holeDomainname(), record.getRdata());
                        record = new ResourceRecord(query.holeDomainname(), "A", ipAdresse);
                        antwort.hinzuAntwortResourceRecord(record.toString());
                    }
                    catch (TimeoutException e) {
                        antwort.hinzuAntwortResourceRecord(record.toString());
                        if ((record = ((DNSServer)this.server).holeRecord(record.getRdata(), "A")) == null) continue;
                        antwort.hinzuAntwortResourceRecord(record.toString());
                    }
                    continue;
                }
                antwort.hinzuAntwortResourceRecord(record.toString());
                if ((record = ((DNSServer)this.server).holeRecord(record.getRdata(), "A")) == null) continue;
                antwort.hinzuAntwortResourceRecord(record.toString());
                continue;
            }
            if (!record.getType().equals("MX")) continue;
            antwort.hinzuAntwortResourceRecord(record.toString());
            if ((record = ((DNSServer)this.server).holeRecord(record.getRdata(), "A")) == null) continue;
            antwort.hinzuAntwortResourceRecord(record.toString());
        }
        if (this.socket != null) {
            ((UDPSocket)this.socket).senden(antwort.toString());
            this.server.benachrichtigeBeobachter(messages.getString("sw_dnsservermitarbeiter_msg2") + "\n>>>>\n" + antwort.toString() + "<<<<");
        }
    }
}

