/*
 * Decompiled with CFR 0.152.
 */
package filius.software.email;

import filius.Main;
import filius.rahmenprogramm.EingabenUeberpruefung;
import filius.rahmenprogramm.I18n;
import filius.software.clientserver.ClientAnwendung;
import filius.software.email.Email;
import filius.software.email.EmailAnwendung;
import filius.software.transportschicht.TCPSocket;
import java.util.LinkedList;
import java.util.ListIterator;

public class POP3Client
extends ClientAnwendung
implements I18n {
    private EmailAnwendung anwendung;

    public POP3Client(EmailAnwendung anwendung) {
        Main.debug.println("INVOKED-2 (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (POP3Client), constr: POP3Client(" + anwendung + ")");
        this.anwendung = anwendung;
        this.setSystemSoftware(anwendung.getSystemSoftware());
    }

    public void emailsHolen(String pop3Server, String pop3Port, String benName, String pw) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (POP3Client), emailsHolen(" + pop3Server + "," + pop3Port + "," + benName + "," + pw + ")");
        Object[] args = new Object[]{pop3Server, new Integer(pop3Port)};
        this.ausfuehren("initialisiereSocket", args);
        args = new Object[]{benName, pw};
        this.ausfuehren("starteVerarbeitung", args);
        this.ausfuehren("schliesseSocket", null);
    }

    public void initialisiereSocket(String zielAdresse, Integer port) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (POP3Client), initialisiereSocket(" + zielAdresse + "," + port + ")");
        try {
            this.socket = new TCPSocket(this.getSystemSoftware(), zielAdresse, (int)port);
            this.socket.verbinden();
        }
        catch (Exception e) {
            e.printStackTrace(Main.debug);
            this.socket = null;
            this.anwendung.benachrichtigeBeobachter(e);
        }
    }

    public void starteVerarbeitung(String benName, String pw) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (POP3Client), starteVerarbeitung(" + benName + "," + pw + ")");
        boolean erfolg = true;
        if (this.socket != null && this.socket.istVerbunden()) {
            try {
                erfolg = this.socket.empfangen().startsWith("+");
                if (erfolg) {
                    erfolg = this.eingabeBenutzername(benName);
                }
                if (erfolg) {
                    erfolg = this.eingabePasswort(pw);
                }
                if (erfolg) {
                    erfolg = this.alleEmailsAbrufen();
                }
                this.sitzungBeenden();
            }
            catch (Exception e) {
                e.printStackTrace(Main.debug);
                this.anwendung.benachrichtigeBeobachter(e);
            }
            this.anwendung.benachrichtigeBeobachter();
        }
    }

    private boolean alleEmailsAbrufen() throws Exception {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (POP3Client), alleEmailsAbrufen()");
        int anzahlMails = 0;
        String auflistung = "";
        LinkedList<Integer> emailIDs = new LinkedList<Integer>();
        String[] statusteile = this.statusAbrufen().split(" ");
        if (statusteile.length > 0) {
            anzahlMails = Integer.parseInt(statusteile[0]);
        }
        if (anzahlMails > 0) {
            auflistung = this.emailsAuflisten();
            String[] zeilen = auflistung.split("\n");
            for (int i = 1; i < zeilen.length; ++i) {
                String zeile = zeilen[i];
                String[] zeichen = zeile.split(" ");
                emailIDs.add(Integer.parseInt(zeichen[0]));
            }
        }
        ListIterator iter = emailIDs.listIterator();
        while (iter.hasNext()) {
            int id = (Integer)iter.next();
            this.emailAbrufen(id);
            this.emailLoeschen(id);
        }
        return true;
    }

    public void schliesseSocket() {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (POP3Client), schliesseSocket()");
        if (this.socket != null) {
            this.socket.schliessen();
            this.socket = null;
            this.benachrichtigeBeobachter(messages.getString("sw_pop3client_msg1"));
        }
    }

    private boolean eingabeBenutzername(String benutzername) throws Exception {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (POP3Client), eingabeBenutzername(" + benutzername + ")");
        if (EingabenUeberpruefung.isGueltig(benutzername, EingabenUeberpruefung.musterMindEinZeichen)) {
            this.socket.senden("USER " + benutzername);
            String empfangen = this.socket.empfangen();
            if (empfangen.startsWith("+OK")) {
                return true;
            }
            throw new Exception(empfangen);
        }
        return false;
    }

    private boolean eingabePasswort(String passwort) throws Exception {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (POP3Client), eingabePasswort(" + passwort + ")");
        if (EingabenUeberpruefung.isGueltig(passwort, EingabenUeberpruefung.musterMindEinZeichen)) {
            this.socket.senden("PASS " + passwort);
            String z = this.socket.empfangen();
            if (z.startsWith("+OK")) {
                return true;
            }
            throw new Exception(z);
        }
        return false;
    }

    private String statusAbrufen() throws Exception {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (POP3Client), statusAbrufen()");
        this.socket.senden("STAT");
        String antwort = this.socket.empfangen();
        if (antwort.startsWith("+OK")) {
            String[] temp = antwort.split(" ");
            String ergebnis = temp[1] + " " + temp[2];
            return ergebnis;
        }
        throw new Exception(antwort);
    }

    private boolean emailsAuflisten(int i) throws Exception {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (POP3Client), emailsAuflisten(" + i + ")");
        this.socket.senden("LIST " + i);
        String ergebnis = this.socket.empfangen();
        if (ergebnis.startsWith("+OK")) {
            return true;
        }
        throw new Exception(ergebnis);
    }

    private String emailsAuflisten() throws Exception {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (POP3Client), emailsAuflisten()");
        this.socket.senden("LIST");
        String ergebnis = this.socket.empfangen();
        if (ergebnis.startsWith("+OK")) {
            return ergebnis;
        }
        throw new Exception(ergebnis);
    }

    private void emailAbrufen(int i) throws Exception {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (POP3Client), emailsAbrufen(" + i + ")");
        this.socket.senden("RETR " + i);
        String result = this.socket.empfangen();
        if (result.startsWith("+OK")) {
            int pos = result.indexOf("\n");
            if (pos > 0) {
                Email neMail = new Email(result.substring(pos + 1));
                this.anwendung.getEmpfangeneNachrichten().add(neMail);
            }
        } else {
            throw new Exception(result);
        }
    }

    private boolean emailLoeschen(int i) throws Exception {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (POP3Client), emailLoeschen(" + i + ")");
        this.socket.senden("DELE " + i);
        String ergebnis = this.socket.empfangen();
        if (ergebnis.startsWith("+OK")) {
            return true;
        }
        throw new Exception(ergebnis);
    }

    private boolean sitzungBeenden() throws Exception {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (POP3Client), sitzungBeenden()");
        this.socket.senden("QUIT");
        String ergebnis = this.socket.empfangen();
        if (ergebnis.startsWith("+OK")) {
            return true;
        }
        throw new Exception(ergebnis);
    }

    private String noop() {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (POP3Client), noop()");
        String ergebnis = "";
        try {
            this.socket.senden("NOOP");
            ergebnis = this.socket.empfangen();
        }
        catch (Exception e) {
            e.printStackTrace(Main.debug);
            ergebnis = "-ERR NOOP failure in Email-Client";
        }
        return ergebnis;
    }
}

