/*
 * Decompiled with CFR 0.152.
 */
package filius.software.netzzugangsschicht;

import filius.Main;
import filius.hardware.Port;
import filius.hardware.knoten.Switch;
import filius.software.ProtokollThread;
import filius.software.netzzugangsschicht.EthernetFrame;
import filius.software.system.SwitchFirmware;
import java.util.LinkedList;
import java.util.ListIterator;

public class SwitchPortBeobachter
extends ProtokollThread {
    private SwitchFirmware switchFirmware;
    private Port anschluss;

    public SwitchPortBeobachter(SwitchFirmware switchFirmware, Port anschluss) {
        super(anschluss.holeEingangsPuffer());
        Main.debug.println("INVOKED-2 (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (SwitchPortBeobachter), constr: SwitchPortBeobachter(" + switchFirmware + "," + anschluss + ")");
        this.switchFirmware = switchFirmware;
        this.anschluss = anschluss;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void verarbeiteDatenEinheit(Object datenEinheit) {
        Main.debug.println("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (SwitchPortBeobachter), verarbeiteDatenEinheit(" + datenEinheit.toString() + ")");
        EthernetFrame etp = (EthernetFrame)datenEinheit;
        if (!this.switchFirmware.holeDurchgelaufeneFrames().contains(etp)) {
            this.switchFirmware.holeDurchgelaufeneFrames().add(etp);
            this.switchFirmware.hinzuSatEintrag(etp.getQuellMacAdresse(), this.anschluss);
            Port zielAnschluss = this.switchFirmware.holeAnschlussFuerMAC(etp.getZielMacAdresse());
            if (zielAnschluss != null) {
                LinkedList<EthernetFrame> linkedList = zielAnschluss.holeAusgangsPuffer();
                synchronized (linkedList) {
                    zielAnschluss.holeAusgangsPuffer().add(etp);
                    zielAnschluss.holeAusgangsPuffer().notify();
                }
            } else {
                ListIterator iter = ((Switch)this.switchFirmware.getKnoten()).getAnschluesse().listIterator();
                while (iter.hasNext()) {
                    Port aktiverAnschluss = (Port)iter.next();
                    if (aktiverAnschluss.isPortFrei() || aktiverAnschluss == this.anschluss) continue;
                    LinkedList<EthernetFrame> linkedList = aktiverAnschluss.holeAusgangsPuffer();
                    synchronized (linkedList) {
                        aktiverAnschluss.holeAusgangsPuffer().add(etp);
                        aktiverAnschluss.holeAusgangsPuffer().notify();
                    }
                }
            }
        }
    }
}

