/*
 * Decompiled with CFR 0.152.
 */
package filius.software.transportschicht;

import filius.Main;
import filius.exception.SocketException;
import filius.exception.TimeOutException;
import filius.exception.VerbindungsException;
import filius.hardware.Verbindung;
import filius.software.system.InternetKnotenBetriebssystem;
import filius.software.transportschicht.Socket;
import filius.software.transportschicht.TcpSegment;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Random;

public class TCPSocket
extends Socket
implements Runnable {
    protected static final int CLOSED = 1;
    protected static final int LISTEN = 2;
    protected static final int SYN_RCVD = 3;
    protected static final int SYN_SENT = 4;
    protected static final int ESTABLISHED = 5;
    protected static final int CLOSE_WAIT = 6;
    protected static final int LAST_ACK = 7;
    protected static final int FIN_WAIT_1 = 8;
    protected static final int FIN_WAIT_2 = 9;
    protected static final int CLOSING = 10;
    protected static final int TIME_WAIT = 11;
    private int zustand = 1;
    protected static final int MAX_SENDEVERSUCHE = 1;
    protected static final int MSS = 1460;
    private LinkedList<TcpSegment> puffer = new LinkedList();
    private long sequenzNummer = 0L;
    private long ackNummer = 0L;

    public TCPSocket(InternetKnotenBetriebssystem betriebssystem, String zielAdresse, int zielPort) throws VerbindungsException {
        super(betriebssystem, zielAdresse, zielPort, 6);
        Main.debug.println("INVOKED-2 (" + this.hashCode() + ") " + this.getClass() + " (TCPSocket), constr: TCPSocket(" + betriebssystem + "," + zielAdresse + "," + zielPort + ")");
    }

    public TCPSocket(InternetKnotenBetriebssystem betriebssystem, int lokalerPort) throws VerbindungsException {
        super(betriebssystem, lokalerPort, 6);
        Main.debug.println("INVOKED-2 (" + this.hashCode() + ") " + this.getClass() + " (TCPSocket), constr: TCPSocket(" + betriebssystem + "," + lokalerPort + ")");
    }

    private void sendeSegment(TcpSegment segment) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (TCPSocket), sendeSegment(" + segment + ")");
        segment.setQuellPort(this.lokalerPort);
        segment.setZielPort(this.zielPort);
        this.protokoll.senden(this.zielIp, segment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void verbinden() throws VerbindungsException, TimeOutException {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (TCPSocket), verbinden()");
        long sendezeit = Long.MAX_VALUE;
        this.puffer.clear();
        this.sequenzNummer = Math.abs(new Random().nextLong()) % ((long)Math.pow(2.0, 32.0) - 1L);
        if (this.modus == 2) {
            this.zustand = 2;
            Main.debug.println("INFO (" + this.hashCode() + "): verbinden() [passiver Modus], Socket: " + this.toString());
            while (this.zustand == 2) {
                LinkedList<TcpSegment> linkedList = this.puffer;
                synchronized (linkedList) {
                    if (this.puffer.size() < 1) {
                        try {
                            this.puffer.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    } else {
                        break;
                    }
                }
            }
            for (int i = 0; i < 2 && this.zustand != 5 && this.zustand != 1; ++i) {
                LinkedList<TcpSegment> linkedList = this.puffer;
                synchronized (linkedList) {
                    if (this.puffer.size() < 1) {
                        try {
                            this.puffer.wait(Verbindung.holeRTT());
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                if (this.puffer.size() >= 1) {
                    sendezeit = System.currentTimeMillis();
                    TcpSegment segment = this.puffer.removeFirst();
                    if (this.zustand == 2 && segment.isSyn()) {
                        this.ackNummer = TCPSocket.naechsteSequenznummer(segment.getSeqNummer());
                        this.zustand = 3;
                        TcpSegment tmp = new TcpSegment();
                        tmp.setSyn(true);
                        tmp.setSeqNummer(this.sequenzNummer);
                        this.sendeAck(segment, tmp);
                        continue;
                    }
                    if (this.zustand == 3 && segment.isAck()) {
                        this.sequenzNummer = segment.getAckNummer();
                        this.zustand = 5;
                        continue;
                    }
                    this.zustand = 1;
                    throw new VerbindungsException(messages.getString("sw_tcpsocket_msg1"));
                }
                if (System.currentTimeMillis() - sendezeit <= (long)Verbindung.holeRTT()) continue;
                this.zustand = 1;
                throw new TimeOutException(messages.getString("sw_tcpsocket_msg2"));
            }
            if (this.zustand == 5) {
                try {
                    this.eintragenPort();
                }
                catch (SocketException e) {
                    e.printStackTrace(Main.debug);
                }
            }
        } else {
            try {
                this.eintragenPort();
                Main.debug.println("INFO (" + this.hashCode() + "): verbinden() [aktiver Modus], Socket: " + this.toString());
                for (int i = 0; this.zustand != 5 && i < 1; ++i) {
                    TcpSegment tmp = new TcpSegment();
                    tmp.setSyn(true);
                    tmp.setSeqNummer(this.sequenzNummer);
                    this.sendeSegment(tmp);
                    this.zustand = 4;
                    LinkedList<TcpSegment> linkedList = this.puffer;
                    synchronized (linkedList) {
                        if (this.puffer.size() < 1) {
                            try {
                                this.puffer.wait(Verbindung.holeRTT());
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                    if (this.puffer.size() >= 1) {
                        TcpSegment segment = this.puffer.removeFirst();
                        if (this.zustand == 4 && segment.isAck() && segment.isSyn()) {
                            this.ackNummer = TCPSocket.naechsteSequenznummer(segment.getSeqNummer());
                            this.sequenzNummer = segment.getAckNummer();
                            this.zustand = 5;
                            this.sendeAck(segment, null);
                            continue;
                        }
                        this.zustand = 1;
                        throw new VerbindungsException(messages.getString("sw_tcpsocket_msg3"));
                    }
                    if (this.zustand == 1) continue;
                    this.zustand = 1;
                    throw new TimeOutException(messages.getString("sw_tcpsocket_msg4"));
                }
                if (this.zustand != 5) {
                    this.austragenPort();
                }
            }
            catch (SocketException e1) {
                e1.printStackTrace(Main.debug);
            }
        }
        if (this.zustand != 5 && this.zustand != 1) {
            this.zustand = 1;
            throw new VerbindungsException(messages.getString("sw_tcpsocket_msg5"));
        }
    }

    protected LinkedList<TcpSegment> erstelleSegmente(String daten) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (TCPSocket), erstelleSegment(" + daten + ")");
        int paketeAnzahl = (int)Math.ceil((float)daten.length() / 1460.0f);
        LinkedList<TcpSegment> segmenteListe = new LinkedList<TcpSegment>();
        for (int i = 1; i <= paketeAnzahl; ++i) {
            TcpSegment segment = new TcpSegment();
            if (daten.length() < 1460) {
                segment.setDaten(daten);
            } else {
                segment.setDaten(daten.substring(0, 1460));
                daten = daten.substring(1460);
            }
            if (i == paketeAnzahl) {
                segment.setPush(true);
            }
            segmenteListe.add(segment);
        }
        return segmenteListe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void senden(String nachricht) throws VerbindungsException, TimeOutException {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (TCPSocket), senden(" + nachricht + ")");
        boolean bestaetigt = true;
        long versendeZeitpunkt = Long.MAX_VALUE;
        if (this.zustand != 5) {
            Main.debug.println("EXCEPTION: " + this.getClass() + " (" + this.hashCode() + "); zustand=" + this.zustand);
            this.zustand = 1;
            throw new VerbindungsException(messages.getString("sw_tcpsocket_msg6"));
        }
        LinkedList<TcpSegment> liste = this.erstelleSegmente(nachricht);
        ListIterator it = liste.listIterator();
        while (it.hasNext() && this.zustand == 5) {
            bestaetigt = false;
            TcpSegment segment = (TcpSegment)it.next();
            segment.setSeqNummer(this.sequenzNummer);
            for (int i = 0; i < 1 && !bestaetigt; ++i) {
                long rtt;
                if (this.zustand != 5) {
                    this.zustand = 1;
                    throw new VerbindungsException(messages.getString("sw_tcpsocket_msg7"));
                }
                this.sendeSegment(segment);
                versendeZeitpunkt = System.currentTimeMillis();
                do {
                    LinkedList<TcpSegment> linkedList = this.puffer;
                    synchronized (linkedList) {
                        if (this.puffer.size() < 1) {
                            try {
                                this.puffer.wait(Verbindung.holeRTT());
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace(Main.debug);
                            }
                        }
                    }
                    linkedList = this.puffer;
                    synchronized (linkedList) {
                        while (this.puffer.size() > 0 && !bestaetigt) {
                            TcpSegment antwort = this.puffer.removeFirst();
                            if (!antwort.isAck() || antwort.getAckNummer() != TCPSocket.naechsteSequenznummer(this.sequenzNummer)) continue;
                            this.sequenzNummer = antwort.getAckNummer();
                            bestaetigt = true;
                        }
                    }
                    rtt = System.currentTimeMillis() - versendeZeitpunkt;
                } while (!bestaetigt && rtt < (long)Verbindung.holeRTT() && this.zustand == 5);
            }
            if (bestaetigt || this.zustand == 1) continue;
            this.zustand = 1;
            throw new TimeOutException(messages.getString("sw_tcpsocket_msg8"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String empfangen() throws VerbindungsException, TimeOutException {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (TCPSocket), empfangen()");
        StringBuffer nachricht = new StringBuffer();
        LinkedList<TcpSegment> segmentListe = new LinkedList<TcpSegment>();
        boolean beendet = false;
        long zeitpunkt = Long.MAX_VALUE;
        if (this.zustand != 5) {
            this.zustand = 1;
            throw new VerbindungsException(messages.getString("sw_tcpsocket_msg9"));
        }
        while (!beendet && this.zustand == 5) {
            LinkedList<TcpSegment> linkedList = this.puffer;
            synchronized (linkedList) {
                if (this.puffer.size() < 1) {
                    try {
                        this.puffer.wait(Verbindung.holeRTT());
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            zeitpunkt = System.currentTimeMillis();
            if (this.zustand == 5 && !beendet && this.puffer.size() >= 1) {
                TcpSegment segment = this.puffer.getFirst();
                if (segment.isAck()) {
                    linkedList = this.puffer;
                    synchronized (linkedList) {
                        try {
                            this.puffer.wait(Verbindung.holeRTT());
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                linkedList = this.puffer;
                synchronized (linkedList) {
                    this.puffer.remove(segment);
                }
                if (segment.getSeqNummer() < this.ackNummer) {
                    this.sendeAck(segment, null);
                } else if (segment.getSeqNummer() == this.ackNummer) {
                    this.sendeAck(segment, null);
                    this.ackNummer = TCPSocket.naechsteSequenznummer(this.ackNummer);
                    segmentListe.add(segment);
                    nachricht.append(segment.getDaten());
                }
                if (segment.isPush()) {
                    beendet = true;
                }
            }
            if (System.currentTimeMillis() - zeitpunkt <= (long)Verbindung.holeRTT()) continue;
            this.zustand = 1;
            throw new TimeOutException(messages.getString("sw_tcpsocket_msg10"));
        }
        if (this.zustand == 5) {
            return nachricht.toString();
        }
        return null;
    }

    @Override
    public void schliessen() {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (TCPSocket), schliessen()");
        new Thread(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (TCPSocket), run()");
        if (this.zustand == 2) {
            this.zustand = 1;
            LinkedList<TcpSegment> linkedList = this.puffer;
            synchronized (linkedList) {
                this.puffer.notifyAll();
            }
        }
        if (this.zustand != 1) {
            TcpSegment tmp = new TcpSegment();
            tmp.setFin(true);
            switch (this.zustand) {
                case 3: 
                case 5: {
                    this.sendeSegment(tmp);
                    this.zustand = 8;
                    break;
                }
                case 4: {
                    this.zustand = 1;
                    LinkedList<TcpSegment> linkedList = this.puffer;
                    synchronized (linkedList) {
                        this.puffer.notifyAll();
                        break;
                    }
                }
                case 6: {
                    this.sendeSegment(tmp);
                    this.zustand = 7;
                }
            }
            for (int i = 0; this.zustand != 1 && i < 5; ++i) {
                LinkedList<TcpSegment> linkedList = this.puffer;
                synchronized (linkedList) {
                    if (this.puffer.size() < 1) {
                        try {
                            this.puffer.wait(Verbindung.holeRTT());
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (this.zustand == 11) {
                        this.puffer.clear();
                        this.zustand = 1;
                    } else if (this.puffer.size() >= 1) {
                        tmp = this.puffer.removeFirst();
                        switch (this.zustand) {
                            case 7: {
                                if (!tmp.isAck()) break;
                                this.zustand = 1;
                                break;
                            }
                            case 10: {
                                if (!tmp.isAck()) break;
                                this.zustand = 11;
                                break;
                            }
                            case 9: {
                                if (!tmp.isFin()) break;
                                this.sendeAck(tmp, null);
                                this.zustand = 11;
                                break;
                            }
                            case 8: {
                                if (tmp.isAck() && tmp.isFin()) {
                                    this.sendeAck(tmp, null);
                                    this.zustand = 11;
                                    break;
                                }
                                if (tmp.isAck()) {
                                    this.zustand = 9;
                                    break;
                                }
                                if (!tmp.isFin()) break;
                                this.sendeAck(tmp, null);
                                this.zustand = 10;
                            }
                        }
                    }
                    continue;
                }
            }
            this.austragenPort();
            if (this.zustand != 1) {
                this.zustand = 1;
            }
        }
    }

    private void sendeAck(TcpSegment empfangSegment, TcpSegment sendeSegment) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (TCPSocket), sendeAck(" + empfangSegment + "," + sendeSegment + ")");
        if (sendeSegment == null) {
            sendeSegment = new TcpSegment();
        }
        sendeSegment.setAck(true);
        sendeSegment.setAckNummer(TCPSocket.naechsteSequenznummer(empfangSegment.getSeqNummer()));
        this.sendeSegment(sendeSegment);
    }

    private static long naechsteSequenznummer(long sequenzNummer) {
        Main.debug.println("INVOKED (static) filius.software.transportschicht.TCPSocket, naechsteSequenznummer(" + sequenzNummer + ")");
        sequenzNummer = (sequenzNummer + 1L) % ((long)Math.pow(2.0, 32.0) - 1L);
        return sequenzNummer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hinzufuegen(String startIp, int startPort, Object segment) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (TCPSocket), hinzufuegen(" + startIp + "," + startPort + "," + segment + ")");
        TcpSegment tcpSegment = (TcpSegment)segment;
        if (this.zustand == 2) {
            this.zielPort = startPort;
            this.zielIp = startIp;
        }
        if (this.zustand == 5 && tcpSegment.isFin()) {
            this.sendeAck(tcpSegment, null);
            this.zustand = 6;
            LinkedList<TcpSegment> linkedList = this.puffer;
            synchronized (linkedList) {
                this.puffer.notifyAll();
            }
        }
        LinkedList<TcpSegment> linkedList = this.puffer;
        synchronized (linkedList) {
            this.puffer.addLast(tcpSegment);
            this.puffer.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beenden() {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (TCPSocket), beenden()");
        this.zustand = 1;
        LinkedList<TcpSegment> linkedList = this.puffer;
        synchronized (linkedList) {
            this.puffer.notifyAll();
        }
    }

    @Override
    public boolean istVerbunden() {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (TCPSocket), istVerbunden(), port: " + this.holeLokalenPort());
        return this.zustand == 5;
    }

    public boolean isSortOfConnected() {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (TCPSocket), isSortOfConnected(), port: " + this.holeLokalenPort());
        return this.zustand >= 5 && this.zustand <= 11;
    }

    @Override
    public String getStateAsString() {
        switch (this.zustand) {
            case 1: {
                return "CLOSED";
            }
            case 2: {
                return "LISTEN";
            }
            case 3: {
                return "SYN_RCVD";
            }
            case 4: {
                return "SYN_SENT";
            }
            case 5: {
                return "ESTABLISHED";
            }
            case 6: {
                return "CLOSE_WAIT";
            }
            case 7: {
                return "LAST_ACK";
            }
            case 8: {
                return "FIN_WAIT_1";
            }
            case 9: {
                return "FIN_WAIT_2";
            }
            case 10: {
                return "CLOSING";
            }
            case 11: {
                return "TIME_WAIT";
            }
        }
        return "<unknown>";
    }
}

