/*
 * Decompiled with CFR 0.152.
 */
package filius.software.vermittlungsschicht;

import filius.rahmenprogramm.I18n;
import filius.rahmenprogramm.Information;
import filius.software.rip.RIPRoute;
import filius.software.rip.RIPTable;
import filius.software.rip.RIPUtil;
import filius.software.system.VermittlungsrechnerBetriebssystem;
import filius.software.vermittlungsschicht.Weiterleitungstabelle;
import filius.software.www.WebServerPlugIn;
import java.io.IOException;

public class VermittlungWeb
extends WebServerPlugIn
implements I18n {
    private VermittlungsrechnerBetriebssystem bs;

    public VermittlungWeb(VermittlungsrechnerBetriebssystem bs) {
        this.bs = bs;
    }

    @Override
    public String holeHtmlSeite(String postDaten) {
        RIPTable table = this.bs.getRIPTable();
        String html = null;
        html = table != null ? this.createRoutingTablePage(table) : this.createForwardingTablePage(this.bs.getWeiterleitungstabelle());
        return html;
    }

    private String createForwardingTablePage(Weiterleitungstabelle weiterleitungstabelle) {
        StringBuffer forwardingEntries = new StringBuffer();
        for (String[] forwardingEntry : weiterleitungstabelle.holeTabelle()) {
            forwardingEntries.append(this.forwardingEntryToHtml(forwardingEntry));
        }
        String html = null;
        try {
            html = this.textDateiEinlesen("tmpl/routing_" + Information.getInformation().getLocale() + ".html");
            html = html.replaceAll(":title:", messages.getString("sw_vermittlungweb_msg5"));
            html = html.replaceAll(":routing_entries:", forwardingEntries.toString());
            html = html.replaceAll(":hint:", messages.getString("sw_vermittlungweb_msg4"));
        }
        catch (IOException e) {
            System.err.println("routing table template could not be read.");
            e.printStackTrace();
        }
        return html;
    }

    private String forwardingEntryToHtml(String[] forwardingEntry) {
        String html = "";
        html = html + "<td>" + forwardingEntry[0] + "</td>";
        html = html + "<td>" + forwardingEntry[1] + "</td>";
        boolean targetIsDirectlyConnected = forwardingEntry[2].equals(forwardingEntry[3]);
        boolean isLocalhost = forwardingEntry[3].equals("127.0.0.1");
        html = targetIsDirectlyConnected || isLocalhost ? html + "<td> 0 </td>" : html + "<td> ? </td>";
        html = html + "<td>" + messages.getString("sw_vermittlungweb_msg3") + "</td>";
        html = html + "<td><a href=\"http://" + forwardingEntry[2] + "/routes\">" + forwardingEntry[2] + "</a></td>";
        html = html + "<td> - </td>";
        boolean isDefaultGateway = forwardingEntry[1].equals("0.0.0.0");
        if (targetIsDirectlyConnected || isLocalhost) {
            return "<tr style='background-color:#aaffaa'>" + html + "</tr>";
        }
        if (isDefaultGateway) {
            return "<tr style='background-color:#aaaaff'>" + html + "</tr>";
        }
        return "<tr>" + html + "</tr>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createRoutingTablePage(RIPTable table) {
        StringBuffer routingEntries = new StringBuffer();
        RIPTable rIPTable = table;
        synchronized (rIPTable) {
            for (RIPRoute route : table.routes) {
                routingEntries.append(this.routeToHtml(route));
            }
        }
        String html = null;
        try {
            html = this.textDateiEinlesen("tmpl/routing_" + Information.getInformation().getLocale() + ".html");
            html = html.replaceAll(":title:", messages.getString("sw_vermittlungweb_msg6"));
            html = html.replaceAll(":routing_entries:", routingEntries.toString());
            html = html.replaceAll(":hint:", messages.getString("sw_vermittlungweb_msg1"));
        }
        catch (IOException e) {
            System.err.println("routing table template could not be read.");
            e.printStackTrace();
        }
        return html;
    }

    private String routeToHtml(RIPRoute route) {
        String html = "";
        html = html + "<td>" + route.getNetAddress() + "</td>";
        html = html + "<td>" + route.getNetMask() + "</td>";
        html = html + "<td>" + route.hops + "</td>";
        if (route.expires == 0L) {
            html = html + "<td>" + messages.getString("sw_vermittlungweb_msg3") + "</td>";
        } else {
            long gueltig = (route.expires - RIPUtil.getTime()) / 1000L;
            html = html + "<td>" + gueltig + "</td>";
        }
        html = html + "<td>" + route.getGateway() + "</td>";
        html = html + "<td><a href=\"http://" + route.hopPublicIp + "/routes\">" + route.hopPublicIp + "</a></td>";
        if (route.hops == 0) {
            return "<tr style='background-color:#aaffaa'>" + html + "</tr>";
        }
        if (route.hops == 16) {
            return "<tr style='background-color:#ffaaaa'>" + html + "</tr>";
        }
        return "<tr>" + html + "</tr>";
    }
}

