/*
 * Decompiled with CFR 0.152.
 */
package filius.software.vermittlungsschicht;

import filius.Main;
import filius.hardware.NetzwerkInterface;
import filius.hardware.knoten.InternetKnoten;
import filius.rahmenprogramm.I18n;
import filius.software.rip.RIPRoute;
import filius.software.rip.RIPTable;
import filius.software.system.InternetKnotenBetriebssystem;
import filius.software.vermittlungsschicht.IP;
import filius.software.vermittlungsschicht.Route;
import filius.software.vermittlungsschicht.RouteNotFoundException;
import filius.software.vermittlungsschicht.VermittlungsProtokoll;
import java.util.LinkedList;

public class Weiterleitungstabelle
implements I18n {
    private LinkedList<String[]> manuelleTabelle;
    private LinkedList<Boolean> manuelleEintraege;
    private InternetKnotenBetriebssystem firmware = null;

    public Weiterleitungstabelle() {
        this.reset();
    }

    public void setInternetKnotenBetriebssystem(InternetKnotenBetriebssystem firmware) {
        this.firmware = firmware;
    }

    public InternetKnotenBetriebssystem getInternetKnotenBetriebssystem() {
        return this.firmware;
    }

    public void setManuelleTabelle(LinkedList<String[]> tabelle) {
        this.manuelleTabelle = tabelle;
    }

    public LinkedList<String[]> getManuelleTabelle() {
        return this.manuelleTabelle;
    }

    public void addManuellenEintrag(String netzwerkziel, String netzwerkmaske, String gateway, String schnittstelle) {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (Weiterleitungstabelle), addManuellenEintrag(" + netzwerkziel + "," + netzwerkmaske + "," + gateway + "," + schnittstelle + ")");
        this.manuelleEintraege = null;
        if (netzwerkziel != null && netzwerkmaske != null && gateway != null && schnittstelle != null) {
            String[] tmpString = new String[]{netzwerkziel, netzwerkmaske, gateway, schnittstelle};
            this.manuelleTabelle.addLast(tmpString);
        }
    }

    public void printTabelle(String name) {
        Main.debug.println("DEBUG (" + name + ") Weiterleitungstabelle (IP,mask,gw,if):");
        for (String[] eintrag : this.holeTabelle()) {
            Main.debug.printf("DEBUG (%s)  '%15s' | '%15s' | '%15s' | '%15s'\n", name, eintrag[0], eintrag[1], eintrag[2], eintrag[3]);
        }
    }

    public LinkedList<Boolean> holeManuelleEintraegeFlags() {
        return this.manuelleEintraege;
    }

    public void reset() {
        this.manuelleTabelle = new LinkedList();
        this.manuelleEintraege = null;
    }

    public LinkedList<String[]> holeTabelle() {
        Main.debug.println("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (Weiterleitungstabelle), holeTabelle()");
        String[] tmp = new String[4];
        LinkedList<String[]> tabelle = new LinkedList<String[]>(this.manuelleTabelle);
        this.manuelleEintraege = new LinkedList();
        for (int i = 0; i < tabelle.size(); ++i) {
            this.manuelleEintraege.add(new Boolean(true));
        }
        if (this.firmware != null) {
            tmp = new String[]{"127.0.0.0", "255.0.0.0", "127.0.0.1", "127.0.0.1"};
            tabelle.addFirst(tmp);
            this.manuelleEintraege.addFirst(new Boolean(false));
            InternetKnoten knoten = (InternetKnoten)this.firmware.getKnoten();
            for (NetzwerkInterface nic : knoten.getNetzwerkInterfaces()) {
                tmp = new String[]{this.berechneNetzkennung(nic.getIp(), nic.getSubnetzMaske()), nic.getSubnetzMaske(), nic.getIp(), nic.getIp()};
                tabelle.addFirst(tmp);
                this.manuelleEintraege.addFirst(new Boolean(false));
            }
            for (NetzwerkInterface nic : knoten.getNetzwerkInterfaces()) {
                tmp = new String[]{nic.getIp(), "255.255.255.255", "127.0.0.1", "127.0.0.1"};
                tabelle.addFirst(tmp);
                this.manuelleEintraege.addFirst(new Boolean(false));
            }
            String gateway = this.firmware.getStandardGateway();
            if (gateway != null && !gateway.trim().equals("")) {
                gateway = gateway.trim();
                tmp = null;
                for (NetzwerkInterface nic : knoten.getNetzwerkInterfaces()) {
                    if (nic == null || !VermittlungsProtokoll.gleichesRechnernetz(gateway, nic.getIp(), nic.getSubnetzMaske())) continue;
                    tmp = new String[]{"0.0.0.0", "0.0.0.0", gateway, nic.getIp()};
                }
                if (tmp == null) {
                    tmp = new String[]{"0.0.0.0", "0.0.0.0", gateway, this.firmware.holeIPAdresse()};
                }
                tabelle.addLast(tmp);
                this.manuelleEintraege.addLast(new Boolean(false));
            }
        }
        return tabelle;
    }

    private String berechneNetzkennung(String ipStr, String maskStr) {
        long ipAddr = IP.inetAton(ipStr);
        long maskAddr = IP.inetAton(maskStr);
        long netAddr = ipAddr & maskAddr;
        return IP.inetNtoa(netAddr);
    }

    @Deprecated
    public String[] holeWeiterleitungsZiele(String zielIpAdresse) throws RouteNotFoundException {
        Route bestRoute = null;
        bestRoute = this.firmware.isRipEnabled() ? this.determineRouteFromDynamicRoutingTable(zielIpAdresse) : this.determineRouteFromStaticRoutingTable(zielIpAdresse);
        return new String[]{bestRoute.getGateway(), bestRoute.getInterfaceIpAddress()};
    }

    public Route holeWeiterleitungsEintrag(String zielIpAdresse) throws RouteNotFoundException {
        Route bestRoute = null;
        bestRoute = this.firmware.isRipEnabled() ? this.determineRouteFromDynamicRoutingTable(zielIpAdresse) : this.determineRouteFromStaticRoutingTable(zielIpAdresse);
        return bestRoute;
    }

    public Route determineRouteFromStaticRoutingTable(String targetIPAddress) throws RouteNotFoundException {
        long zielAddr = IP.inetAton(targetIPAddress);
        long bestMask = -1L;
        Route bestRoute = null;
        for (String[] route : this.holeTabelle()) {
            long netAddr;
            long maskAddr = IP.inetAton(route[1]);
            if (maskAddr <= bestMask || (netAddr = IP.inetAton(route[0])) != (maskAddr & zielAddr)) continue;
            bestMask = maskAddr;
            bestRoute = new Route(route);
        }
        if (bestRoute != null) {
            return bestRoute;
        }
        throw new RouteNotFoundException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Route determineRouteFromDynamicRoutingTable(String ip) throws RouteNotFoundException {
        RIPTable table = this.firmware.getRIPTable();
        RIPRoute bestRoute = null;
        RIPTable rIPTable = table;
        synchronized (rIPTable) {
            int bestHops = 15;
            long bestMask = -1L;
            for (RIPRoute route : table.routes) {
                if (!route.getNetAddress().equals(this.berechneNetzkennung(ip, route.getNetMask())) || bestHops < route.hops || bestHops <= route.hops && bestMask >= IP.inetAton(route.getNetMask())) continue;
                bestRoute = route;
                bestHops = route.hops;
                bestMask = IP.inetAton(route.getNetMask());
            }
        }
        if (bestRoute != null) {
            return bestRoute;
        }
        throw new RouteNotFoundException();
    }
}

